/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.kSG;
import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAnalyzedAudioFile;
import com.bitwig.flt.app.testing.tests.BitwigStudioTestDataFileTest;
import com.bitwig.flt.sample_analysis.c;
import com.bitwig.flt.sample_analysis.fEf;
import com.bitwig.flt.sample_analysis.sSK;
import com.bitwig.flt.sample_analysis.uuS;
import java.io.File;
import java.io.IOException;

public class OnsetAnalysisTests
extends BitwigStudioTestDataFileTest {
    @Override
    protected String getTopLevelDirectoryPath() {
        return "audio-file-analysis";
    }

    @Override
    protected boolean shouldCreateTestForFileType(ZdU zdU) {
        return zdU instanceof XVR;
    }

    @S1a
    public void testBitwigVampPluginHostOnsetAnalyzer() {
        c c2 = this.getApplication().dwj();
        this.check(c2).jJc();
        File file = c2.nrS();
        this.check(file).gBO();
        File file2 = this.getFile().RXU();
        File file3 = this.getOutputFile("detected.onsets");
        com.bitwig.flt.sample_analysis.kSG kSG2 = new com.bitwig.flt.sample_analysis.kSG(file, file3);
        kSG2.DVW(file2);
        this.check(file3).hAB();
        File file4 = this.getExpectedFile("onsets").RXU();
        sSK.DVW(file4);
        this.checkOnsetsAreCorrect(file3, file4);
    }

    @S1a
    public void testOnsetAnalysisViaCache() {
        c c2 = this.getApplication().dwj();
        this.check(c2).jJc();
        File file = this.getFile().RXU();
        fEf fEf2 = c2.DVW(new kSG(file));
        this.check(fEf2).jJc();
        File file2 = c2.nrS();
        this.check(file2).gBO();
        TestAnalyzedAudioFile testAnalyzedAudioFile = new TestAnalyzedAudioFile((BitwigStudioTest)this, fEf2);
        uuS uuS2 = testAnalyzedAudioFile.DVW(file, file2);
        this.check(file2).gBO();
        File file3 = fEf2.DVW(file2);
        this.check(uuS2).jJc();
        int n4 = uuS2.DVW();
        this.check(n4 > 0);
        double d3 = -1.0;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d4 = uuS2.DVW(i2);
            this.check(d4 >= 0.0);
            this.check(d4 > d3);
            double d5 = uuS2.gBO(i2);
            this.check(d5).DVW(0.0, 2.0);
            d3 = d4;
        }
        File file4 = this.getExpectedFile("onsets").RXU();
        this.checkOnsetsAreCorrect(file3, file4);
    }

    private void checkOnsetsAreCorrect(File file, File file2) {
        this.check("onsets correct", file).DVW(file2, () -> {
            uuS uuS2 = this.loadOnsets(file);
            this.check(file2).hAB();
            uuS uuS3 = this.loadOnsets(file2);
            this.check("onset count", uuS2.DVW()).DVW(uuS3.DVW());
            int n4 = uuS2.DVW();
            this.check(n4 > 0);
            for (int i2 = 0; i2 < n4; ++i2) {
                double d3;
                double d4 = uuS2.DVW(i2);
                double d5 = Math.abs(d4 - (d3 = uuS3.DVW(i2)));
                this.check(d5 < 1.0E-4);
            }
        });
    }

    private uuS loadOnsets(File file) {
        uuS uuS2 = null;
        try {
            uuS2 = sSK.DVW(file);
        }
        catch (IOException iOException) {
            this.fail("load onsets file " + file.getAbsolutePath(), iOException);
        }
        this.check(uuS2).jJc();
        int n4 = uuS2.DVW();
        this.check(n4 > 0);
        double d3 = -1.0;
        for (int i2 = 0; i2 < n4; ++i2) {
            double d4 = uuS2.DVW(i2);
            this.check(d4 >= 0.0);
            this.check(d4 > d3);
            double d5 = uuS2.gBO(i2);
            this.check(d5).DVW(0.0, 2.0);
            d3 = d4;
        }
        return uuS2;
    }
}

