/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.NBU;
import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.MJG;
import com.bitwig.flt.app.testing.TestChannel;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestPluginDevice;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.tests.BitwigStudioLocallyInstalledFileTest;
import com.bitwig.flt.device.tev;
import com.bitwig.flt.document.core.master.device.eUa;
import com.bitwig.flt.library.metadata.master.CcF;
import com.bitwig.flt.library.metadata.master.UVM;
import com.bitwig.flt.library.metadata.master.rBp;
import java.io.File;
import java.util.concurrent.TimeUnit;

public class LocallyInstalledPluginsTest
extends BitwigStudioLocallyInstalledFileTest {
    private TestProject mProject;
    private TestDeviceChain mDeviceChain;

    @Override
    protected String getTopLevelTestDataDirectoryPath() {
        return "plugins";
    }

    @Override
    protected boolean shouldCreateTestForFileType(ZdU zdU) {
        return zdU instanceof fUD;
    }

    @Override
    protected boolean shouldCreateTestForFile(nwb nwb2) {
        if (this.isFileBlacklisted(nwb2)) {
            return false;
        }
        return super.shouldCreateTestForFile(nwb2);
    }

    private boolean isFileBlacklisted(nwb nwb2) {
        if (ZjF.DVW()) {
            String string = nwb2.jpF();
            String string2 = nwb2.jJc();
            if (string2.equalsIgnoreCase("dll") && string.startsWith("iZ") && !string.startsWith("iZotope")) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setupDescendandTest(NBU nBU2) {
        Object object;
        super.setupDescendandTest(nBU2);
        LocallyInstalledPluginsTest locallyInstalledPluginsTest = (LocallyInstalledPluginsTest)nBU2;
        if (this.mProject == null || ((iuL)this.mProject.hAB()).O_()) {
            this.mProject = locallyInstalledPluginsTest.createTestProject(0, 0);
            object = this.mProject.DVW(vNA.DVW);
            this.mDeviceChain = ((TestChannel)object).jJc();
        }
        object = (MJG)((iuL)this.mProject.hAB()).zER();
        ((MJG)object).DVW(locallyInstalledPluginsTest);
        locallyInstalledPluginsTest.mProject = new TestProject((BitwigStudioTest)locallyInstalledPluginsTest, (iuL)this.mProject.hAB());
        locallyInstalledPluginsTest.mDeviceChain = new TestDeviceChain((BitwigStudioTest)locallyInstalledPluginsTest, (eUa)this.mDeviceChain.hAB());
        locallyInstalledPluginsTest.openedProject(locallyInstalledPluginsTest.mProject);
    }

    @Override
    protected void tearDownDescendantTest(NBU nBU2, boolean bl2) {
        super.tearDownDescendantTest(nBU2, bl2);
        if (!bl2) {
            LocallyInstalledPluginsTest locallyInstalledPluginsTest = (LocallyInstalledPluginsTest)nBU2;
            locallyInstalledPluginsTest.mProject.jJc();
            this.mProject = null;
            this.mDeviceChain = null;
        }
    }

    @S1a
    public void canReadMetadata() {
        File file = this.getFile().RXU();
        rBp rBp2 = (rBp)EHw.hAB().XHT(file);
        this.check(rBp2 instanceof UVM || rBp2 instanceof CcF);
        UVM uVM = rBp2 instanceof UVM ? (UVM)rBp2 : ((CcF)rBp2).DnY();
        this.check(uVM).jJc();
        this.check("File is correct", uVM.bMm()).DVW(file);
        this.check("Has some plugins", uVM.UY2() > 0);
        fUD fUD2 = uVM.jpF();
        this.check(fUD2).jJc();
        ZdU zdU = ZdU.a_(file);
        this.cast(fUD2, zdU.getClass());
        long l2 = uVM.LsI();
        this.check("File size correct", l2).DVW(file.length());
        long l3 = uVM.WCJ();
        this.check("Last modified time correct", l3).DVW(file.lastModified());
    }

    @S1a(XHT=3)
    public void canLoadPlugin() {
        this.mProject.pxg();
        int n4 = this.mDeviceChain.qhn();
        File file = this.getFile().RXU();
        this.mDeviceChain.DVW(file, 0);
        this.check("Device Count", this.mDeviceChain.qhn()).DVW(n4 + 1);
        TestPluginDevice testPluginDevice = (TestPluginDevice)this.cast(this.mDeviceChain.gBO(0), TestPluginDevice.class);
        tev tev2 = (tev)this.cast(testPluginDevice.iRw(), tev.class);
        rBp rBp2 = (rBp)EHw.hAB().XHT(file);
        this.check(rBp2 instanceof UVM || rBp2 instanceof CcF);
        CcF ccF2 = rBp2 instanceof CcF ? (CcF)rBp2 : ((UVM)this.cast(rBp2, UVM.class)).DVW(0);
        tev tev3 = ccF2.Mdo();
        this.check("Device id correct", tev2).DVW(tev3);
        testPluginDevice.WCJ();
        this.check("Device loaded successfully", testPluginDevice.LsI()).DVW(rzE.lTJ);
        testPluginDevice.lTJ();
        this.waitForDeviceToBeDeleted(n4);
    }

    private void waitForDeviceToBeDeleted(int n4) {
        long l2 = 50L;
        long l3 = 5000L;
        long l4 = 100L;
        for (long i2 = 0L; i2 < 100L; ++i2) {
            int n5 = this.mDeviceChain.qhn();
            if (n5 <= n4) {
                return;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.addCheck(new tyh("Plugin deleted", 5000L, TimeUnit.MILLISECONDS));
    }
}

