/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestChainSelector;
import com.bitwig.flt.app.testing.TestChainSelectorIndexedValueAtom;
import com.bitwig.flt.app.testing.TestDeviceChain;
import com.bitwig.flt.app.testing.TestIndexedValueAtom;
import com.bitwig.flt.app.testing.TestIndexedValueType;
import com.bitwig.flt.app.testing.TestNativeDevice;
import com.bitwig.flt.app.testing.TestNestedDeviceChain;
import com.bitwig.flt.app.testing.TestPermanentAutomationLane;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.kSG;
import com.bitwig.flt.document.core.master.device.eOt;
import java.util.UUID;

public abstract class ChainSelectorTests
extends BitwigStudioTest {
    protected abstract UUID getDeviceId();

    protected abstract vNA getTrackType();

    private TestChainSelector createAndGetChainSelector() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        return (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
    }

    @S1a
    public void checkAddDeleteSimple() {
        TestChainSelector testChainSelector = this.createAndGetChainSelector();
        this.check("ChainSelectorEmpty", testChainSelector.jpF()).DVW(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.qhn().nrS()).DVW(0);
        testChainSelector.nrS();
        this.check("ChainSelectorEmpty", testChainSelector.jpF()).DVW(1);
        this.check("SelectedIndexWhileEmpty", testChainSelector.qhn().nrS()).DVW(0);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.gBO(0);
        testNestedDeviceChain.lTJ();
        this.check("ChainSelectorEmpty", testChainSelector.jpF()).DVW(0);
        this.check("SelectedIndexWhileEmpty", testChainSelector.qhn().nrS()).DVW(0);
    }

    @S1a
    public void checkAddDeleteComplex() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
            this.check("chainCount", testChainSelector.jpF()).DVW(i2 + 1);
            String string = "Test Chain " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain = testChainSelector.gBO(i2);
            testNestedDeviceChain.gBO(string);
            this.check("title", testNestedDeviceChain.nrS()).DVW(string);
            this.check("displayedTitle", testNestedDeviceChain.jpF()).DVW(string);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        this.check("indexInit", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelector.nrS();
        this.check("indexAfterAddChain", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        this.check("chainCount", testChainSelector.jpF()).DVW(6);
        testChainSelector.gBO(0).lTJ();
        this.check("indexAfterRemoveChain", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        this.check("chainCount", testChainSelector.jpF()).DVW(5);
        testChainSelector.gBO(1).lTJ();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        this.check("chainCount", testChainSelector.jpF()).DVW(4);
        testChainSelectorIndexedValueAtom.gBO(2);
        testChainSelector.gBO(0).lTJ();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        this.check("chainCount", testChainSelector.jpF()).DVW(3);
        testChainSelectorIndexedValueAtom.gBO(2);
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        testChainSelector.gBO(2).lTJ();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        this.check("chainCount", testChainSelector.jpF()).DVW(2);
    }

    @S1a
    public void checkMoveToFirst() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        testChainSelectorIndexedValueAtom.gBO(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.gBO(0);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.gBO(2);
        testNestedDeviceChain.Mdo().DVW(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.jpF()).DVW(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).DVW(testChainSelector.gBO(0));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).DVW(testChainSelector.gBO(1));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
    }

    public void checkMoveToLast() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        testChainSelectorIndexedValueAtom.gBO(2);
        this.check("indexBeforeMove", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.gBO(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.gBO(2);
        testNestedDeviceChain.pxg().DVW(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.jpF()).DVW(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).DVW(testChainSelector.gBO(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).DVW(testChainSelector.gBO(3));
        this.check("indexAfterMove", testChainSelectorIndexedValueAtom.nrS()).DVW(4);
    }

    @S1a
    public void checkDuplicate() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
        }
        testTrack.F_().fJ1();
    }

    @S1a
    public void checkPrevNextArrows() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        this.check("index when empty", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index when empty after selectNextValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index when empty after selectPrevValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index when empty after cycleNextValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index when empty after cyclePrevValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelector.nrS();
        this.check("index with a single chain", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index with a single chain after selectNextValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index with a single chain after selectPrevValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index with a single chain after cycleNextValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index with a single chain after cyclePrevValue()", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelector.nrS();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index next at end", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index prev", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelector.nrS();
        this.check("index with two chains", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        testChainSelectorIndexedValueAtom.jpF();
        this.check("index next at end", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index prev", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index prev", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.jJc();
        this.check("index prev at beginning", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        testChainSelectorIndexedValueAtom.fJ1();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(2);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(1);
        testChainSelectorIndexedValueAtom.pxg();
        this.check("index cycleNext", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
    }

    @S1a
    public void checkAutomation() {
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
        }
        this.check("chainCount", testChainSelector.jpF()).DVW(5);
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        TestIndexedValueType testIndexedValueType = testChainSelectorIndexedValueAtom.qhn();
        this.check("indexValueTypeIsAutomatable", testIndexedValueType.qhn());
        this.check("indexValueTypeIsInterpolated", !testIndexedValueType.nrS());
        testChainSelectorIndexedValueAtom.Mdo();
        TestPermanentAutomationLane testPermanentAutomationLane = testTrack.DVW(testChainSelectorIndexedValueAtom);
        TestNestedDeviceChain testNestedDeviceChain = testChainSelector.gBO(4);
        TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector.gBO(2);
        testNestedDeviceChain.pxg().DVW(testNestedDeviceChain2);
        this.check("chainsCount", testChainSelector.jpF()).DVW(5);
        this.check("chainMovedPosition", testNestedDeviceChain2).DVW(testChainSelector.gBO(4));
        this.check("chainMovedBeforePosition", testNestedDeviceChain).DVW(testChainSelector.gBO(3));
    }

    @S1a
    public void checkMoveBetweenTwoDevices() {
        Object object;
        TestNestedDeviceChain testNestedDeviceChain;
        Object object2;
        TestProject testProject = this.createTestProject(0, 0);
        TestTrack testTrack = testProject.DVW(this.getTrackType());
        TestDeviceChain testDeviceChain = testTrack.jJc();
        TestNativeDevice testNativeDevice = testDeviceChain.DVW(0, this.getDeviceId());
        TestChainSelector testChainSelector = (TestChainSelector)this.cast(testNativeDevice.DVW(eOt.class), TestChainSelector.class);
        TestNativeDevice testNativeDevice2 = testDeviceChain.DVW(1, this.getDeviceId());
        TestChainSelector testChainSelector2 = (TestChainSelector)this.cast(testNativeDevice2.DVW(eOt.class), TestChainSelector.class);
        for (int i2 = 0; i2 < 5; ++i2) {
            testChainSelector.nrS();
            testChainSelector2.nrS();
            this.check("chainCount1", testChainSelector.jpF()).DVW(i2 + 1);
            this.check("chainCount2", testChainSelector2.jpF()).DVW(i2 + 1);
            object2 = "Test Chain1 " + (i2 + 1);
            testNestedDeviceChain = testChainSelector.gBO(i2);
            testNestedDeviceChain.gBO((String)object2);
            this.check("title", testNestedDeviceChain.nrS()).DVW((String)object2);
            this.check("displayedTitle", testNestedDeviceChain.jpF()).DVW((String)object2);
            object = "Test Chain2 " + (i2 + 1);
            TestNestedDeviceChain testNestedDeviceChain2 = testChainSelector2.gBO(i2);
            testNestedDeviceChain2.gBO((String)object);
            this.check("title", testNestedDeviceChain2.nrS()).DVW((String)object);
            this.check("displayedTitle", testNestedDeviceChain2.jpF()).DVW((String)object);
        }
        TestChainSelectorIndexedValueAtom testChainSelectorIndexedValueAtom = testChainSelector.qhn();
        this.check("indexInit1", testChainSelectorIndexedValueAtom.nrS()).DVW(0);
        object2 = testChainSelector2.qhn();
        this.check("indexInit2", ((TestIndexedValueAtom)object2).nrS()).DVW(0);
        testChainSelectorIndexedValueAtom.gBO(2);
        ((TestIndexedValueAtom)object2).gBO(2);
        testNestedDeviceChain = testChainSelector.gBO(2);
        object = testChainSelector2.gBO(2);
        testNestedDeviceChain.pxg().DVW((kSG)object);
        this.check("index1", testChainSelector.qhn().nrS()).DVW(2);
        this.check("chainsCount1", testChainSelector.jpF()).DVW(6);
        this.check("index2", testChainSelector2.qhn().nrS()).DVW(2);
        this.check("chainsCount2", testChainSelector2.jpF()).DVW(4);
    }
}

