/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.flt.app.testing.LvV;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioSource;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.tests.AudioRecordingOrBouncingTests;
import com.bitwig.flt.app.testing.tests.MwA;
import java.io.File;
import java.util.Collection;

public abstract class BounceTests
extends AudioRecordingOrBouncingTests {
    private jqp mSampleBitDepth;
    private Boolean mShouldBounceInRealtime;

    @Override
    public String getTestName() {
        if (this.mShouldBounceInRealtime != null) {
            if (this.mSampleBitDepth == null) {
                return this.mShouldBounceInRealtime != false ? "realtime" : "offline";
            }
        } else {
            return this.getClass().getSimpleName();
        }
        return super.getTestName();
    }

    @Override
    protected String getMethodNodeName() {
        return this.mSampleBitDepth.XHT();
    }

    @Override
    protected void listChildren(Collection collection) {
        if (this.mShouldBounceInRealtime == null) {
            BounceTests bounceTests = (BounceTests)this.createChild();
            bounceTests.mShouldBounceInRealtime = Boolean.FALSE;
            collection.add(bounceTests);
            BounceTests bounceTests2 = (BounceTests)this.createChild();
            bounceTests2.mShouldBounceInRealtime = Boolean.TRUE;
            collection.add(bounceTests2);
        } else if (this.mSampleBitDepth == null) {
            for (jqp jqp2 : jqp.values()) {
                BounceTests bounceTests = (BounceTests)this.createChild();
                bounceTests.mSampleBitDepth = jqp2;
                collection.add(bounceTests);
            }
        } else {
            super.listChildren(collection);
        }
    }

    @Override
    protected TestAudioNoteClipEvent recordClip(TestProject testProject, TestTrack testTrack, double d3, double d4, MwA mwA) {
        File file = this.getExpectedRecordedFile();
        file.delete();
        TestAudioSource testAudioSource = testTrack.vCp();
        Ywa ywa2 = (Ywa)this.get(() -> this.createBounceRequest((RWP)testAudioSource.hAB(), d3, d4, file));
        ywa2.DVW(mwA.ordinal());
        try {
            TestAudioNoteClipEvent testAudioNoteClipEvent = testAudioSource.DVW(ywa2, this.mSampleBitDepth, this.mShouldBounceInRealtime);
            if (mwA != MwA.DVW) {
                this.fail("Should have reported error bouncing");
            }
            return testAudioNoteClipEvent;
        }
        catch (LvV lvV) {
            if (mwA == MwA.DVW) {
                throw lvV;
            }
            return lvV.DVW();
        }
    }

    protected abstract Ywa createBounceRequest(RWP var1, double var2, double var4, File var6);

    @Override
    protected File getExpectedRecordedFile() {
        return this.getOutputFile(this.mSampleBitDepth + (this.mShouldBounceInRealtime != false ? "-realtime" : "") + ".wav", false);
    }

    @Override
    protected int getExpectedBitsPerSample() {
        switch (this.mSampleBitDepth) {
            case XHT: {
                return 32;
            }
            case DVW: {
                return 16;
            }
            case gBO: {
                return 24;
            }
        }
        this.fail("Unknown sample bit depeth");
        return 0;
    }

    @Override
    protected Class getErrorNotificationType() {
        return wbt.class;
    }
}

