/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.io.kSG;
import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.BitwigStudioTest;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTempoAutomationEventTimeline;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.MwA;
import java.io.File;

public abstract class AudioRecordingOrBouncingTests
extends BitwigStudioTest {
    @S1a
    public void testRecordingAudio() {
        this.testRecordingAudio(0.0, 4.0, 120.0);
    }

    @S1a
    public void testRecordingShortAudio() {
        double d3 = 120.0;
        this.testRecordingAudio(0.0, uLA.DVW(this.getBlockBeatLength(120.0) * 2.0), 120.0);
    }

    private void testRecordingAudio(double d3, double d4, double d5) {
        this.checkBeatTime(d3).gBO().hAB(0.0);
        this.checkBeatTime("record duration", d4).gBO().XHT(0.0);
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        TestTransport testTransport = testProject.nrS();
        testTransport.nrS().DVW(d5);
        TestTrack testTrack = testProject.DVW(vNA.gBO);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, d3, d4, MwA.DVW);
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d5, d4, this.getExpectedDurationInBeatsTolerance(d5), this.getExpectedRecordedFile(), MwA.DVW);
    }

    protected File getExpectedRecordedFile() {
        return null;
    }

    @S1a
    public void testRecordingAudioWithIOErrorOnOpen() {
        this.testRecordingAudioWithError(MwA.gBO);
    }

    @S1a
    public void testRecordingAudioWithIOErrorOnWrite() {
        this.testRecordingAudioWithError(MwA.XHT);
    }

    @S1a
    public void testRecordingAudioWithIOErrorOnClose() {
        this.testRecordingAudioWithError(MwA.hAB);
    }

    private void testRecordingAudioWithError(MwA mwA) {
        double d3;
        double d4;
        this.check(mwA != MwA.DVW);
        this.check("no error with recording audio so far", this.getFirstNotificationOfType(this.getErrorNotificationType())).jpF();
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        double d5 = testProject.nrS().nrS().qhn();
        TestTrack testTrack = testProject.DVW(vNA.gBO);
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 4.0, mwA);
        if (mwA == MwA.gBO || mwA == MwA.XHT) {
            d4 = 0.0;
            d3 = 0.0;
        } else {
            d4 = 0.0;
            d3 = 0.0;
        }
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d5, 4.0, this.getExpectedDurationInBeatsTolerance(d5), d4, d3, this.getExpectedRecordedFile(), mwA);
        this.check("error notification was shown", this.getFirstNotificationOfType(this.getErrorNotificationType())).jJc();
    }

    @S1a
    public void testRecordingAudioWithTempoAutomation() {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        TestTransport testTransport = testProject.nrS();
        testTransport.nrS().Mdo();
        TestTrack testTrack = testProject.DVW(vNA.gBO);
        TestTempoAutomationEventTimeline testTempoAutomationEventTimeline = (TestTempoAutomationEventTimeline)this.cast(testProject.jpF().pxg().gBO(testTransport.nrS()).qhn(), TestTempoAutomationEventTimeline.class);
        double d3 = 120.0;
        int n4 = 24;
        double d4 = 200.0;
        int n5 = 8;
        int n6 = 16;
        int n7 = 4;
        testTempoAutomationEventTimeline.DVW(0.0, 120.0);
        testTempoAutomationEventTimeline.DVW(8.0, 200.0);
        testTempoAutomationEventTimeline.DVW(16.0, 200.0);
        testTempoAutomationEventTimeline.DVW(24.0, 120.0);
        int n8 = 66;
        TestAudioNoteClipEvent testAudioNoteClipEvent = this.recordClip(testProject, testTrack, 0.0, 24.0, MwA.DVW);
        this.check("recorded clip", testAudioNoteClipEvent).jJc();
        this.check("start time", testAudioNoteClipEvent.D2F()).DVW(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.DVW(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.nrS()).DVW(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.gBO(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.D2F()).DVW(0.0);
        this.check(!testAudioNoteEvent.iRw());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.nrS();
        this.check("warp event count", testWarpEventTimeline.nrS()).DVW(66);
        TestSampleReference testSampleReference = testAudioNoteEvent.qhn();
        testSampleReference.jpF();
        double d5 = testSampleReference.jJc();
        double d6 = 24.0;
        this.check(!testSampleReference.nrS());
        String string = testSampleReference.qhn().qhn().qhn();
        File file = new File(string);
        this.check("recorded file", file).hAB().nrS().gBO(0L);
        bHN bHN2 = bHN.gBO(nwb.XHT(file));
        double d7 = bHN2.vCp();
        this.check("file duration", d7).gBO(d5, 7.0);
        bHO bHO2 = bHN2.bfM();
        this.check("metadata chunk", bHO2).jJc();
        bHM bHM2 = bHO2.DVW();
        this.check("warp markers", bHM2).jJc();
        int n9 = bHM2.XHT();
        this.check("warp marker count", n9).DVW(66);
        for (int i2 = 0; i2 < 32; ++i2) {
            double d8 = (double)i2 / 4.0;
            double d9 = testProject.DVW(d8);
            this.checkWarpMarkerWithTempoAutomation(i2, bHM2, testWarpEventTimeline, d8, d9);
        }
        this.checkWarpMarkerWithTempoAutomation(n9 - 1, bHM2, testWarpEventTimeline, 24.0, d7);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, bHM2);
    }

    private void checkWarpMarkerWithTempoAutomation(int n4, bHM bHM2, TestWarpEventTimeline testWarpEventTimeline, double d3, double d4) {
        bHL bHL2 = bHM2.DVW(n4);
        double d5 = bHL2.gBO();
        this.check("warp marker beat time " + n4, d5).DVW(d3, 3);
        if (n4 > 0 && n4 < bHM2.XHT() - 1) {
            this.checkBeatTime("warp marker " + n4 + " beat time", d5).XHT();
        }
        this.check("warp marker sample time " + n4, bHL2.DVW()).DVW(d4, 1);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.gBO(n4), TestWarpEvent.class);
        double d6 = testWarpEvent.D2F();
        this.checkBeatTime("warp event beat time " + n4, d6).gBO();
        if (n4 > 0 && n4 < bHM2.XHT() - 1) {
            this.checkBeatTime("warp event beat time " + n4, d5).XHT();
        }
        this.check("warp event sample time " + n4, testWarpEvent.qhn()).DVW(bHL2.DVW());
    }

    protected abstract TestAudioNoteClipEvent recordClip(TestProject var1, TestTrack var2, double var3, double var5, MwA var7);

    protected double getExpectedDurationInBeatsTolerance(double d3) {
        return 0.0;
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d3, double d4, double d5, File file, MwA mwA) {
        double d6 = d4 / d3 * 60.0;
        double d7 = d5 != 0.0 ? d5 / d3 * 60.0 : 1.0 / (double)this.getSampleRate();
        this.checkAudioClipNoTempoAutomation(testAudioNoteClipEvent, d3, d4, d5, d6, d7, file, mwA);
    }

    private void checkAudioClipNoTempoAutomation(TestAudioNoteClipEvent testAudioNoteClipEvent, double d3, double d4, double d5, double d6, double d7, File file, MwA mwA) {
        this.check("clip", testAudioNoteClipEvent).jJc();
        this.check("start time", testAudioNoteClipEvent.D2F()).DVW(0.0);
        TestAudioNoteEventTimeline testAudioNoteEventTimeline = (TestAudioNoteEventTimeline)this.cast(testAudioNoteClipEvent.DVW(0, 0), TestAudioNoteEventTimeline.class);
        this.check("event count", testAudioNoteEventTimeline.nrS()).DVW(1);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteEventTimeline.gBO(0), TestAudioNoteEvent.class);
        this.check("event time", testAudioNoteEvent.D2F()).DVW(0.0);
        this.check(!testAudioNoteEvent.iRw());
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.nrS();
        int n4 = testWarpEventTimeline.nrS();
        this.check("warp event count", n4).DVW(2);
        TestSampleReference testSampleReference = testAudioNoteEvent.qhn();
        testSampleReference.jpF();
        double d8 = testSampleReference.jJc();
        if (mwA == MwA.DVW) {
            this.check("sample ref duration", d8).gBO(d6, d7);
        }
        double d9 = testAudioNoteClipEvent.jpF();
        this.checkBeatTime("clip duration", d9).gBO().gBO(d4, d5);
        this.check("event duration", testAudioNoteEvent.jpF()).DVW(d9);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.gBO(0), TestWarpEvent.class);
        this.check("first warp event time", testWarpEvent.D2F()).DVW(0.0);
        this.check("first warp event sample time", testWarpEvent.qhn()).DVW(0.0);
        TestWarpEvent testWarpEvent2 = (TestWarpEvent)this.cast(testWarpEventTimeline.gBO(n4 - 1), TestWarpEvent.class);
        this.check("last warp event time", testWarpEvent2.D2F()).DVW(d9);
        if (mwA == MwA.DVW) {
            this.check("last warp event sample time", testWarpEvent2.qhn()).DVW(d8);
        }
        this.check(!testSampleReference.nrS());
        String string = testSampleReference.qhn().qhn().qhn();
        File file2 = new File(string);
        if (file != null) {
            this.check(file.getPath()).DVW(file2.getPath());
        }
        if (mwA == MwA.DVW) {
            this.checkAudioFile(file2, d8, d9);
        }
    }

    protected void checkAudioFile(File file, double d3, double d4) {
        this.check("file", file).hAB().nrS().gBO(0L);
        bHN bHN2 = bHN.gBO(nwb.XHT(file));
        this.check("sample rate correct", bHN2.szR()).DVW(this.getSampleRate());
        this.check("channel count correct", bHN2.iRw()).DVW(2);
        this.check("bit depth correct", bHN2.D2F()).DVW(this.getExpectedBitsPerSample());
        double d5 = bHN2.vCp();
        this.check("file duration", d5).gBO(d3, 7.0);
        bHO bHO2 = bHN2.bfM();
        this.check("metadata chunk", bHO2).jJc();
        bHM bHM2 = bHO2.DVW();
        this.check("warp markers", bHM2).jJc();
        int n4 = bHM2.XHT();
        this.check("warp marker count", n4).DVW(2).lTJ(2);
        bHL bHL2 = bHM2.DVW(0);
        this.check("first warp marker beat time", bHL2.gBO()).DVW(0.0);
        this.check("first warp marker sample time", bHL2.DVW()).DVW(0.0);
        bHL bHL3 = bHM2.DVW(n4 - 1);
        this.checkBeatTime("last warp marker beat time", bHL3.gBO()).lTJ(d4);
        this.check("last warp marker sample time", bHL3.DVW()).DVW(d5);
        this.checkLoadingAudioNoteHasExpectedWarpMarkers(file, bHM2);
    }

    private void checkLoadingAudioNoteHasExpectedWarpMarkers(File file, bHM bHM2) {
        j1r j1r2 = new j1r(new kSG(file));
        int n4 = 60;
        j1r2.DVW(60.0, true);
        bHM bHM3 = j1r2.hAB();
        this.check("loaded sample info has warp markers", bHM3).jJc();
        this.checkHasSameWarpMarkers(bHM2, bHM3);
        ozV ozV2 = ozV.DVW(j1r2, TlI.gBO, 60.0);
        LBQ lBQ = ozV2.BFa().zzR();
        this.checkWarpEventsAreCorrectForWarpMarkers(lBQ, bHM2);
    }

    private void checkHasSameWarpMarkers(bHM bHM2, bHM bHM3) {
        this.check(bHM2.XHT()).gBO(bHM3.XHT());
        for (int i2 = 0; i2 < bHM2.XHT(); ++i2) {
            bHL bHL2 = bHM2.DVW(i2);
            bHL bHL3 = bHM3.DVW(i2);
            this.check("Warp marker " + (i2 + 1) + " is the same", bHL2).DVW(bHL3);
        }
    }

    private void checkWarpEventsAreCorrectForWarpMarkers(LBQ lBQ, bHM bHM2) {
        int n4 = lBQ.WCJ();
        int n5 = bHM2.XHT();
        this.check("warp event count is correct", n4).DVW(n5);
        for (int i2 = 0; i2 < Math.min(n5, n4); ++i2) {
            bHL bHL2 = bHM2.DVW(i2);
            FOH fOH = lBQ.gBO(i2);
            this.check("Warp event " + (i2 + 1) + " beat time is correct", fOH.KQG()).DVW(uLA.DVW(bHL2.gBO()));
            this.check("Warp event " + (i2 + 1) + " sample time is correct", fOH.lTJ()).DVW(bHL2.DVW());
        }
    }

    protected abstract int getExpectedBitsPerSample();

    protected abstract Class getErrorNotificationType();
}

