/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing.tests;

import com.bitwig.base.testing.S1a;
import com.bitwig.flt.app.testing.TestAudioNoteClipEvent;
import com.bitwig.flt.app.testing.TestAudioNoteEvent;
import com.bitwig.flt.app.testing.TestCueMarkerTimeline;
import com.bitwig.flt.app.testing.TestLoopRegion;
import com.bitwig.flt.app.testing.TestNoteClipEventTimeline;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.TestSampleReference;
import com.bitwig.flt.app.testing.TestTrack;
import com.bitwig.flt.app.testing.TestTransport;
import com.bitwig.flt.app.testing.TestWarpEvent;
import com.bitwig.flt.app.testing.TestWarpEventTimeline;
import com.bitwig.flt.app.testing.tests.AudioRecordingTests;
import java.io.File;

public class ArrangerAudioRecordingTests
extends AudioRecordingTests {
    @Override
    protected void beforeRecording(TestProject testProject, TestTrack testTrack) {
        testProject.nrS().gBO(true);
    }

    @Override
    protected TestAudioNoteClipEvent getRecordedClip(TestTrack testTrack) {
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack.pxg();
        this.check("clip count", testNoteClipEventTimeline.nrS()).DVW(1);
        TestAudioNoteClipEvent testAudioNoteClipEvent = (TestAudioNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(0), TestAudioNoteClipEvent.class);
        return testAudioNoteClipEvent;
    }

    @S1a
    public void testRecordingAudioInLoop() {
        this.testRecordingAudioInLoop(0.0, 1);
    }

    @S1a
    public void testRecordingAudioInLoop2() {
        this.testRecordingAudioInLoop(0.0, 2);
    }

    @S1a
    public void testRecordingAudioInLoop3() {
        this.testRecordingAudioInLoop(4.0, 1);
    }

    private void testRecordingAudioInLoop(double d3, int n4) {
        TestProject testProject = this.createTestProject(1, 0);
        testProject.pxg();
        TestCueMarkerTimeline testCueMarkerTimeline = testProject.qhn();
        double d4 = 4.0;
        TestLoopRegion testLoopRegion = testCueMarkerTimeline.qhn();
        testLoopRegion.XHT(d3);
        testLoopRegion.DVW(4.0);
        testCueMarkerTimeline.gBO(true);
        TestTransport testTransport = testProject.nrS();
        testTransport.gBO(true);
        double d5 = testTransport.nrS().qhn();
        TestTrack testTrack = testProject.DVW(vNA.gBO);
        TestTrack testTrack2 = testProject.DVW(vNA.gBO);
        testTrack2.szR().DVW(testTrack.LsI());
        testTrack2.gBO(true);
        double d6 = (double)n4 * 4.0 + 2.0;
        testTransport.DVW(d3, d6);
        TestNoteClipEventTimeline testNoteClipEventTimeline = testTrack2.pxg();
        this.check("clip count", testNoteClipEventTimeline.nrS()).DVW(2);
        TestAudioNoteClipEvent testAudioNoteClipEvent = (TestAudioNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(0), TestAudioNoteClipEvent.class);
        TestAudioNoteClipEvent testAudioNoteClipEvent2 = (TestAudioNoteClipEvent)this.cast(testNoteClipEventTimeline.gBO(1), TestAudioNoteClipEvent.class);
        this.check("first clip start time", testAudioNoteClipEvent.D2F()).DVW(d3);
        double d7 = testAudioNoteClipEvent2.D2F();
        this.check("no gap between clips", d7).DVW(testAudioNoteClipEvent.jJc());
        this.check("second clip start time correct", d7).gBO(d3 + 2.0, this.getBlockBeatLength(d5));
        this.check("last clip end time", testAudioNoteClipEvent2.jJc()).DVW(d3 + 4.0);
        TestAudioNoteEvent testAudioNoteEvent = (TestAudioNoteEvent)this.cast(testAudioNoteClipEvent.DVW(0, 0).gBO(0), TestAudioNoteEvent.class);
        TestWarpEventTimeline testWarpEventTimeline = testAudioNoteEvent.nrS();
        int n5 = testWarpEventTimeline.nrS();
        this.check(n5).equals(2);
        TestWarpEvent testWarpEvent = (TestWarpEvent)this.cast(testWarpEventTimeline.gBO(n5 - 1), TestWarpEvent.class);
        double d8 = testWarpEvent.D2F();
        double d9 = testWarpEvent.qhn();
        this.check(d8).gBO(d6, this.getBlockBeatLength(d5));
        TestSampleReference testSampleReference = testAudioNoteEvent.qhn();
        testSampleReference.jpF();
        File file = new File(testSampleReference.qhn().qhn().qhn());
        this.checkAudioFile(file, d9, d8);
    }
}

