/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.flt.app.testing;

import com.bitwig.base.io.yhy;
import com.bitwig.base.testing.AnnotationBasedTest;
import com.bitwig.flt.app.testing.Dzz;
import com.bitwig.flt.app.testing.MJG;
import com.bitwig.flt.app.testing.NBU;
import com.bitwig.flt.app.testing.TestPackageManager;
import com.bitwig.flt.app.testing.TestProject;
import com.bitwig.flt.app.testing.c;
import com.bitwig.flt.app.testing.khs;
import com.bitwig.flt.app.testing.sSK;
import com.bitwig.flt.app.testing.wQa;
import com.bitwig.ramona.core.Slf;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public abstract class BitwigStudioTest
extends AnnotationBasedTest {
    private static final int DEFAULT_OPEN_PROJECT_TIMEOUT = 30;
    private int mEngineAssertFileCount = 0;

    @Override
    protected void beforeRun() {
        super.beforeRun();
        this.mEngineAssertFileCount = 0;
    }

    @Override
    protected void afterRun() {
        super.afterRun();
        this.addEngineAssertions();
    }

    public int getSampleRate() {
        return 44100;
    }

    public int getBlockSize() {
        return 512;
    }

    private void addEngineAssertions() {
        int n4 = this.mEngineAssertFileCount;
        if (n4 == 0) {
            return;
        }
        f2E f2E2 = new f2E();
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = this.getEngineAssertsFile(i2, false);
            try {
                f2E2.DVW((File)object);
                continue;
            }
            catch (IOException iOException) {
                LOG.hAB("Error parsing engine assertions file " + (File)object, iOException);
            }
        }
        for (Object object : f2E2.DVW()) {
            this.addCheck(new r3R("Engine", ((Lnu)object).DVW(), ((Lnu)object).gBO(), ((Lnu)object).XHT(), ((Lnu)object).hAB(), ((Lnu)object).lTJ()));
        }
    }

    @Override
    public String getObjectAsString(Object object) {
        if (object instanceof Slf) {
            Slf slf = (Slf)object;
            return (String)this.get(slf::toString);
        }
        return super.getObjectAsString(object);
    }

    public c checkBeatTime(double d3) {
        return new c(this, d3);
    }

    public c checkBeatTime(String string, double d3) {
        return new c(this, d3, string);
    }

    protected khs getApplication() {
        return (khs)this.getEventProcessor();
    }

    protected File getOutputFile(String string) {
        return this.getOutputFile(string, true);
    }

    protected File getOutputFile(String string, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("test-output");
        stringBuilder.append('/');
        BitwigStudioTest.appendTestPathAsFilePath(this, stringBuilder);
        stringBuilder.append('/');
        stringBuilder.append(string);
        File file = this.getTestDataFile(stringBuilder.toString(), false).zm();
        if (bl2 && file.exists()) {
            file.delete();
        }
        file.getParentFile().mkdirs();
        return file;
    }

    private static void appendTestPathAsFilePath(com.bitwig.base.testing.NBU nBU2, StringBuilder stringBuilder) {
        com.bitwig.base.testing.NBU nBU3 = nBU2.getParent();
        if (nBU3 != null) {
            BitwigStudioTest.appendTestPathAsFilePath(nBU3, stringBuilder);
            stringBuilder.append('/');
        }
        stringBuilder.append(yhy.jJc(nBU2.getTestName()));
    }

    protected TestProject createTestProject(int n4, int n5) {
        assert (bqI.gBO(!this.isEventDispatchThread()));
        xOg xOg2 = new xOg();
        this.getApplication().DVW(() -> this.getApplication().DVW(n4, n5, new MJG(this), xOg2));
        iuL iuL2 = (iuL)this.waitForAsyncTask("New document", xOg2, 5L, TimeUnit.SECONDS);
        TestProject testProject = new TestProject(this, iuL2);
        this.openedProject(testProject);
        return testProject;
    }

    protected TestProject createTestProject() {
        return this.createTestProject(0, 0);
    }

    protected void openedProject(TestProject testProject) {
        Dzz dzz = this.getTestRunnerService();
        if (dzz.LsI().gBO()) {
            testProject.pxg();
        }
    }

    protected TestProject openTestProject(String string) {
        return this.openTestProject(string, 30);
    }

    protected TestProject openTestProject(String string, int n4) {
        return this.openTestProject(this.getTestProjectFile(string), n4);
    }

    protected File getTestProjectFile(String string) {
        return this.getTestDataFile("test-data/projects/" + string + "/" + string + ".bwproject").RXU();
    }

    protected TestProject openTestProject(nwb nwb2) {
        return this.openTestProject(nwb2.RXU());
    }

    protected TestProject openTestProject(File file) {
        return this.openTestProject(file, 30);
    }

    protected TestProject openTestProject(File file, int n4) {
        TestProject testProject = new TestProject(this, this.openProject(file, n4));
        this.openedProject(testProject);
        return testProject;
    }

    private iuL openProject(File file, int n4) {
        this.check(this.isTestRunnerThread());
        this.check(file).lTJ();
        khs khs2 = this.getApplication();
        xOg xOg2 = new xOg();
        MJG mJG = new MJG(this);
        this.asyncExec(() -> khs2.DVW(file, mJG, xOg2));
        return (iuL)this.waitForAsyncTask("Open project " + file.getName(), xOg2, (long)n4, TimeUnit.SECONDS);
    }

    protected void compareWavFiles(File file, File file2, Ylu ylu) {
        this.check("output", file).DVW(file2, () -> {
            Object object;
            Object object2;
            long l2 = 0L;
            this.check(file).hAB();
            this.check(file2).hAB();
            if (file.isFile() && file2.isFile()) {
                try {
                    object2 = dhC.DVW(file);
                    try {
                        object = dhC.DVW(file2);
                        try {
                            l2 = ((dhC)object2).gBO();
                            this.check("numFrames", ((dhC)object2).gBO()).DVW(((dhC)object).gBO());
                            this.check("numChannels", ((dhC)object2).DVW()).DVW(((dhC)object).DVW());
                            this.check("sampleRate", ((dhC)object2).XHT()).DVW(((dhC)object).XHT());
                        }
                        finally {
                            if (object != null) {
                                ((dhC)object).close();
                            }
                        }
                    }
                    finally {
                        if (object2 != null) {
                            ((dhC)object2).close();
                        }
                    }
                }
                catch (dhE | IOException exception) {
                    this.fail(exception);
                }
            }
            object2 = new uro();
            object = yhy.lTJ(file.getAbsolutePath()) + ".diff.wav";
            try (dhC dhC2 = dhC.DVW(new File((String)object), 2, l2, 24, 44100L);){
                boolean bl2 = EpS.DVW(file2, file, (sGH)object2, dhC2);
                this.check("compareWaveFiles", bl2);
                if (bl2) {
                    double d3 = 0.0;
                    double d4 = ylu == Ylu.DVW ? -90.0 : 0.0;
                    double d5 = -24.0;
                    this.addDecibelCheck("Exact", ((uro)object2).DVW(), 0.0);
                    this.addDecibelCheck("Shift One", ((uro)object2).gBO(), d4);
                    this.addDecibelCheck("Moving Average", ((uro)object2).XHT(), -24.0);
                }
            }
            catch (dhE | IOException exception) {
                this.fail(exception);
            }
        });
    }

    protected void addDecibelCheck(String string, double d3, double d4) {
        double d5 = S1V.hAB(d3);
        this.addCheck(string, d5 < d4, this.formatDecibels(d5), "below " + this.formatDecibels(d4), false);
    }

    protected String formatDecibels(double d3) {
        if (d3 < -160.0) {
            return "-\u221e";
        }
        return Integer.toString((int)d3);
    }

    public TestPackageManager getPackageManager() {
        return (TestPackageManager)this.getTestObject(this.getApplication()::nqb, TestPackageManager.class);
    }

    protected wQa getTestObject(Supplier supplier) {
        wQa wQa2 = this.getOptTestObject(supplier);
        this.check(wQa2).jJc();
        return wQa2;
    }

    protected wQa getTestObject(Supplier supplier, Class clazz) {
        wQa wQa2 = this.getTestObject(supplier);
        return (wQa)this.cast(wQa2, clazz);
    }

    protected wQa getOptTestObject(Supplier supplier, Class clazz) {
        wQa wQa2 = this.getOptTestObject(supplier);
        if (wQa2 == null) {
            return null;
        }
        return (wQa)this.cast(wQa2, clazz);
    }

    protected wQa getOptTestObject(Supplier supplier) {
        Object object = this.getOpt(supplier);
        if (object == null) {
            return null;
        }
        return sSK.DVW(this, object);
    }

    public wQa createTestObject(Object object) {
        return sSK.DVW(this, object);
    }

    public wQa createTestObject(Object object, Class clazz) {
        wQa wQa2 = sSK.DVW(this, object);
        return (wQa)this.cast(wQa2, clazz);
    }

    @Override
    public NBU getTestRunner() {
        return (NBU)super.getTestRunner();
    }

    public Dzz getTestRunnerService() {
        NBU nBU2 = this.getTestRunner();
        if (nBU2 == null) {
            return null;
        }
        return (Dzz)nBU2.gBO().DVW();
    }

    public File getEngineLogFile() {
        return this.getOutputFile("engine.log", false);
    }

    public final File getNextEngineAssertsFile() {
        assert (bqI.gBO(this.isEventDispatchThread()));
        ++this.mEngineAssertFileCount;
        return this.getEngineAssertsFile(this.mEngineAssertFileCount - 1, true);
    }

    public final int getEngineAssertsFileCount() {
        return this.mEngineAssertFileCount;
    }

    public File getEngineAssertsFile(int n4, boolean bl2) {
        return this.getOutputFile("engine-asserts" + (n4 + 1) + ".txt", bl2);
    }

    @Override
    protected com.bitwig.base.testing.NBU createChild() {
        BitwigStudioTest bitwigStudioTest = (BitwigStudioTest)super.createChild();
        bitwigStudioTest.mEngineAssertFileCount = 0;
        return bitwigStudioTest;
    }

    public double getSampleBeatLength(double d3) {
        double d4 = d3 / 60.0;
        int n4 = this.getSampleRate();
        double d5 = 1.0 / (double)n4;
        return d5 * d4;
    }

    public double getBlockBeatLength(double d3) {
        return this.getSampleBeatLength(d3) * (double)this.getBlockSize();
    }

    public double getBlockDurationInSeconds() {
        return (double)this.getBlockSize() / (double)this.getSampleRate();
    }

    public WJG getFirstNotificationOfType(Class clazz) {
        return (WJG)this.getOpt(() -> (WJG)this.getApplication().n_().DVW(clazz));
    }
}

