/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extension.controller.api;

import com.bitwig.extension.api.Color;

public class HardwareLightVisualState {
    private final Color mColor;
    private final Color mBlinkOffColor;
    private final Color mLabelColor;
    private final Color mLabelBlinkOffColor;
    private final double mOnBlinkTime;
    private final double mOffBlinkTime;

    private static Color defaultLabelColorForLightColor(Color color) {
        double d3 = color.getRed() + color.getGreen() + color.getBlue();
        return d3 >= 1.5 ? Color.blackColor() : Color.whiteColor();
    }

    public static HardwareLightVisualState createForColor(Color color) {
        return HardwareLightVisualState.createForColor(color, HardwareLightVisualState.defaultLabelColorForLightColor(color));
    }

    public static HardwareLightVisualState createForColor(Color color, Color color2) {
        return new HardwareLightVisualState(color, null, color2, null, 0.0, 0.0);
    }

    public static HardwareLightVisualState createBlinking(Color color, Color color2, double d3, double d4) {
        return new HardwareLightVisualState(color, color2, HardwareLightVisualState.defaultLabelColorForLightColor(color), HardwareLightVisualState.defaultLabelColorForLightColor(color2), d3, d4);
    }

    public static HardwareLightVisualState createBlinking(Color color, Color color2, Color color3, Color color4, double d3, double d4) {
        return new HardwareLightVisualState(color, color2, color3, color4, d3, d4);
    }

    private HardwareLightVisualState(Color color, Color color2, Color color3, Color color4, double d3, double d4) {
        this.mColor = color;
        this.mBlinkOffColor = color2;
        this.mLabelColor = color3;
        this.mLabelBlinkOffColor = color4;
        this.mOnBlinkTime = d3;
        this.mOffBlinkTime = d4;
    }

    public boolean isBlinking() {
        return this.mBlinkOffColor != null;
    }

    public Color getColor() {
        return this.mColor;
    }

    public Color getBlinkOffColor() {
        return this.mBlinkOffColor;
    }

    public double getOffBlinkTime() {
        return this.mOffBlinkTime;
    }

    public double getOnBlinkTime() {
        return this.mOnBlinkTime;
    }

    public Color getLabelColor() {
        return this.mLabelColor;
    }

    public Color getLabelBlinkOffColor() {
        return this.mLabelBlinkOffColor;
    }
}

