/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.extension.api;

public class Color {
    private final double mRed;
    private final double mGreen;
    private final double mBlue;
    private final double mAlpha;

    private Color(double d3, double d4, double d5, double d6) {
        this.mRed = d3;
        this.mGreen = d4;
        this.mBlue = d5;
        this.mAlpha = d6;
    }

    public static Color fromRGB(double d3, double d4, double d5) {
        return new Color(d3, d4, d5, 1.0);
    }

    public static Color fromRGBA(double d3, double d4, double d5, double d6) {
        return new Color(d3, d4, d5, d6);
    }

    public static Color fromRGB255(int n4, int n5, int n6) {
        return new Color((double)n4 / 255.0, (double)n5 / 255.0, (double)n6 / 255.0, 1.0);
    }

    public static Color fromRGBA255(int n4, int n5, int n6, int n7) {
        return new Color((double)n4 / 255.0, (double)n5 / 255.0, (double)n6 / 255.0, (double)n7 / 255.0);
    }

    public static Color fromHex(String string) {
        int n4;
        int n5;
        if (string.isEmpty()) {
            return Color.nullColor();
        }
        if (string.charAt(0) == '#') {
            string = string.substring(1);
        }
        for (n5 = 0; n5 < string.length(); ++n5) {
            n4 = string.charAt(n5);
            if (48 <= n4 && n4 <= 57 || 97 <= n4 && n4 <= 102 || 65 <= n4 && n4 <= 70) continue;
            return Color.nullColor();
        }
        switch (string.length()) {
            case 3: {
                n5 = Integer.parseInt(string.substring(0, 1), 16);
                n4 = Integer.parseInt(string.substring(1, 2), 16);
                int n6 = Integer.parseInt(string.substring(2, 3), 16);
                return Color.fromRGB((double)n5 / 15.0, (double)n4 / 15.0, (double)n6 / 15.0);
            }
            case 4: {
                n5 = Integer.parseInt(string.substring(0, 1), 16);
                n4 = Integer.parseInt(string.substring(1, 2), 16);
                int n7 = Integer.parseInt(string.substring(2, 3), 16);
                int n8 = Integer.parseInt(string.substring(2, 3), 16);
                return Color.fromRGBA((double)n5 / 15.0, (double)n4 / 15.0, (double)n7 / 15.0, (double)n8 / 15.0);
            }
            case 6: {
                n5 = Integer.parseInt(string.substring(0, 2), 16);
                n4 = Integer.parseInt(string.substring(2, 4), 16);
                int n9 = Integer.parseInt(string.substring(4, 6), 16);
                return Color.fromRGB255(n5, n4, n9);
            }
            case 8: {
                n5 = Integer.parseInt(string.substring(0, 2), 16);
                n4 = Integer.parseInt(string.substring(2, 4), 16);
                int n10 = Integer.parseInt(string.substring(4, 6), 16);
                int n11 = Integer.parseInt(string.substring(6, 8), 16);
                return Color.fromRGBA255(n5, n4, n10, n11);
            }
        }
        return Color.nullColor();
    }

    public static Color mix(Color color, Color color2, double d3) {
        double d4 = d3;
        double d5 = 1.0 - d3;
        return new Color(color.getRed() * d4 + color2.getRed() * d5, color.getGreen() * d4 + color2.getGreen() * d5, color.getBlue() * d4 + color2.getBlue() * d5, color.getAlpha() * d4 + color2.getAlpha() * d5);
    }

    public static Color nullColor() {
        return Color.fromRGBA(0.0, 0.0, 0.0, 0.0);
    }

    public static Color blackColor() {
        return Color.fromRGBA(0.0, 0.0, 0.0, 1.0);
    }

    public static Color whiteColor() {
        return Color.fromRGBA(1.0, 1.0, 1.0, 1.0);
    }

    public double getRed() {
        return this.mRed;
    }

    public double getGreen() {
        return this.mGreen;
    }

    public double getBlue() {
        return this.mBlue;
    }

    public double getAlpha() {
        return this.mAlpha;
    }

    public int getRed255() {
        return (int)(this.mRed * 255.0);
    }

    public int getGreen255() {
        return (int)(this.mGreen * 255.0);
    }

    public int getBlue255() {
        return (int)(this.mBlue * 255.0);
    }

    public int getAlpha255() {
        return (int)(this.mAlpha * 255.0);
    }
}

