/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.sound;

import com.bitwig.base.io.GXb;
import com.bitwig.base.sound.InvalidMIDIPitchNameException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NBU {
    private static final String[] XHT = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    private static final String[] hAB = new String[]{"C ", "C\u266f", "D ", "D\u266f", "E ", "F ", "F\u266f", "G ", "G\u266f", "A ", "A\u266f", "B "};
    private static final String[] lTJ = new String[]{"B#", "Db", "D", "Eb", "Fb", "E#", "Gb", "G", "Ab", "A", "Bb", "Cb"};
    public static final double DVW = 440.0 * Math.pow(2.0, -5.75);

    public static void DVW(File file, int n4, int n5, int n6, InputStream inputStream, long l2) {
        NBU.DVW(nwb.XHT(file), n4, n5, n6, inputStream, l2);
    }

    public static void DVW(nwb nwb2, int n4, int n5, int n6, InputStream inputStream, long l2) {
        OutputStream outputStream = nwb2.WCJ();
        try {
            NBU.DVW(outputStream, n4, n5, n6, inputStream, l2);
        }
        catch (IOException iOException) {
            try {
                outputStream.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        outputStream.close();
    }

    public static void DVW(OutputStream outputStream, int n4, int n5, int n6, InputStream inputStream, long l2) {
        int n7 = (int)(l2 & 1L);
        long l3 = l2 + 36L + (long)n7;
        if (l3 < 0L || (l3 & 0xFFFFFFFF00000000L) != 0L) {
            throw new IOException("Invalid sample data size " + l2);
        }
        GXb gXb = GXb.DVW(outputStream, ByteOrder.LITTLE_ENDIAN);
        gXb.DVW(NBU.nrS("RIFF"));
        gXb.DVW((int)l3);
        gXb.DVW(NBU.nrS("WAVE"));
        gXb.DVW(NBU.nrS("fmt "));
        gXb.DVW(16);
        gXb.DVW((short)1);
        gXb.DVW((short)n5);
        gXb.DVW(n4);
        gXb.DVW(n4 * n5 * n6 / 8);
        gXb.DVW((short)(n5 * n6 / 8));
        gXb.DVW((short)n6);
        gXb.DVW(NBU.nrS("data"));
        gXb.DVW((int)l2);
        byte[] byArray = new byte[Math.min(1024, (int)l2)];
        long l4 = l2;
        while (l4 > 0L) {
            assert (bqn.gBO(l4 > 0L));
            int n8 = (int)Math.min((long)byArray.length, l4);
            int n9 = inputStream.read(byArray, 0, n8);
            if (n9 < 0) {
                throw new EOFException();
            }
            gXb.write(byArray, 0, n9);
            assert (bqn.gBO((l4 -= (long)n9) >= 0L));
        }
        assert (bqn.gBO(l4 == 0L));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (n7 > 0) {
            gXb.write(0);
        }
        gXb.flush();
    }

    private static int nrS(String string) {
        assert (bqn.gBO(string.length() == 4));
        return string.charAt(0) | string.charAt(1) << 8 | string.charAt(2) << 16 | string.charAt(3) << 24;
    }

    public static String[] DVW() {
        return XHT;
    }

    public static String DVW(int n4) {
        return String.valueOf(n4 + 1);
    }

    public static String gBO(int n4) {
        if (n4 < 0) {
            return "-";
        }
        int n5 = NBU.XHT(n4);
        int n6 = NBU.hAB(n4);
        String string = XHT[n5] + n6;
        return string;
    }

    public static int XHT(int n4) {
        return n4 % 12;
    }

    public static int hAB(int n4) {
        return n4 / 12 - 2;
    }

    public static boolean lTJ(int n4) {
        return NBU.qhn(NBU.XHT(n4));
    }

    public static boolean qhn(int n4) {
        return n4 == 1 || n4 == 3 || n4 == 6 || n4 == 8 || n4 == 10;
    }

    public static String DVW(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isDigit(c2) && c2 != '-') continue;
            return string.substring(0, i2);
        }
        return string;
    }

    public static int gBO(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!Character.isDigit(c2) && c2 != '-') continue;
            try {
                return jw2.hAB(string.substring(i2));
            }
            catch (jZi jZi2) {
                throw new InvalidMIDIPitchNameException(string);
            }
        }
        throw new InvalidMIDIPitchNameException(string);
    }

    public static int XHT(String string) {
        Pattern pattern = Pattern.compile("([^A-Za-z0-9])([A-Ga-g][#bB]?)(-?[0-9])([^A-Za-z0-9])");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string2 = matcher.group(2);
            String string3 = matcher.group(3);
            try {
                int n4 = jw2.hAB(string3);
                int n5 = NBU.DVW(string2, n4);
                return n5;
            }
            catch (InvalidMIDIPitchNameException invalidMIDIPitchNameException) {
            }
            catch (jZi jZi2) {
            }
        }
        return -1;
    }

    public static int DVW(String string, int n4) {
        int n5;
        if (string.length() < 1) {
            throw new InvalidMIDIPitchNameException(string + n4);
        }
        String string2 = string.toUpperCase();
        char c2 = string2.charAt(0);
        char[] cArray = new char[]{'C', '\u0000', 'D', '\u0000', 'E', 'F', '\u0000', 'G', '\u0000', 'A', '\u0000', 'B'};
        int n6 = -1;
        for (n5 = 0; n5 < cArray.length; ++n5) {
            if (cArray[n5] == '\u0000' || c2 != cArray[n5]) continue;
            n6 = n5 + (n4 + 2) * 12;
            break;
        }
        if (n6 == -1) {
            throw new InvalidMIDIPitchNameException(string + n4);
        }
        for (n5 = 1; n5 < string2.length(); ++n5) {
            char c4 = string2.charAt(n5);
            if (c4 == '#') {
                ++n6;
                continue;
            }
            if (c4 == 'B') {
                --n6;
                continue;
            }
            throw new InvalidMIDIPitchNameException("unexpected character: " + c4);
        }
        return n6;
    }

    public static int hAB(String string) {
        int n4 = NBU.gBO(string);
        String string2 = NBU.DVW(string).toUpperCase();
        for (int i2 = 0; i2 < XHT.length; ++i2) {
            if (string2.equals(XHT[i2])) {
                int n5 = i2 + (n4 + 2) * 12;
                assert (bqn.gBO(NBU.gBO(n5).equalsIgnoreCase(string)));
                return n5;
            }
            if (!string2.equals(lTJ[i2].toUpperCase())) continue;
            int n6 = i2 + (n4 + 2) * 12;
            if (i2 == 0) {
                return n6 + 12;
            }
            if (i2 == 11) {
                return n6 - 12;
            }
            return n6;
        }
        throw new InvalidMIDIPitchNameException(string);
    }

    public static double lTJ(String string) {
        int n4 = NBU.hAB(string);
        return DVW * Math.pow(2.0, (double)n4 / 12.0);
    }

    public static double qhn(String string) {
        String string2 = string.toLowerCase();
        int n4 = string2.lastIndexOf("bpm");
        if (n4 != -1 && n4 != 0) {
            char c2;
            int n5 = n4 - 1;
            char c4 = string2.charAt(n5);
            if (!Character.isLetterOrDigit(c4)) {
                --n5;
            }
            if (n5 < 1) {
                return -1.0;
            }
            int n6 = n5;
            int n7 = n5;
            while (n7 >= 0 && (Character.isDigit(c2 = string2.charAt(n7)) || c2 == ',' || c2 == '.')) {
                n6 = n7--;
            }
            if (n5 > n6) {
                String string3 = string2.substring(n6, n5 + 1).replace(",", ".");
                try {
                    Double d3 = Double.valueOf(string3);
                    return d3;
                }
                catch (NumberFormatException numberFormatException) {
                    return -1.0;
                }
            }
        }
        return -1.0;
    }

    public static double DVW(double d3) {
        return 12.0 * (Math.log(d3 / DVW) * (1.0 / Math.log(2.0)));
    }

    public static double gBO(double d3) {
        return DVW * Math.pow(2.0, d3 / 12.0);
    }

    public static String XHT(double d3) {
        if (d3 < DVW) {
            return "";
        }
        double d4 = NBU.DVW(d3);
        double d5 = Math.round(d4);
        int n4 = (int)d5 % 12;
        int n5 = (int)d5 / 12 - 2;
        double d6 = d4 - d5;
        int n6 = (int)Math.round(d6 * 100.0);
        String string = n6 >= 30 ? "\u02e5" : (n6 >= 10 ? "\u02e6" : (n6 <= -30 ? "\u02e9" : (n6 < -10 ? "\u02e8" : "\u02e7")));
        String string2 = string + "  " + hAB[n4] + n5;
        return string2;
    }

    public static boolean nrS(int n4) {
        return n4 >= 0 && n4 <= 15;
    }

    public static boolean jpF(int n4) {
        return n4 >= 0 && n4 <= 127;
    }

    public static boolean jJc(int n4) {
        return n4 >= 0 && n4 <= 119;
    }

    public static boolean fJ1(int n4) {
        return n4 >= 0 && n4 <= 127;
    }

    public static boolean pxg(int n4) {
        return n4 >= 1 && n4 <= 127;
    }

    public static double hAB(double d3) {
        if (d3 <= 0.0) {
            d3 = 1.0;
        }
        return 6.0E7 / d3;
    }

    public static int Mdo(int n4) {
        return ~n4 & 0xFFFF;
    }
}

