/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.platform;

import com.bitwig.base.io.GRo;
import com.bitwig.base.io.ProcessException;
import com.bitwig.base.io.Vfa;
import com.bitwig.base.io.rZx;
import com.bitwig.base.io.yhy;
import com.bitwig.base.platform.MacOsXIoKit;
import com.bitwig.base.platform.WindowsPlatform;
import com.bitwig.base.platform.WindowsRegistry;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.UUID;

public final class Platform {
    private static String gBO;
    private static UUID XHT;
    private static boolean hAB;
    private static File lTJ;
    private static File qhn;

    public static void DVW() {
        if (!hAB) {
            ZjF.gBO("base-platform");
            hAB = true;
        }
    }

    public static String gBO() {
        if (gBO == null) {
            gBO = Platform.jpF();
        }
        assert (bqc.XHT(gBO != null));
        assert (bqc.XHT(!gBO.isEmpty()));
        return gBO;
    }

    private static String jpF() {
        if (ZjF.gBO()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            String string2 = Platform.getNativeComputerName();
            if (string2 != null && !string2.isEmpty()) {
                return string2;
            }
            try {
                bqc.DVW.hAB("Warning: determining macOS host name failed, using fallback instead.");
                string2 = InetAddress.getLocalHost().getHostName();
                if (string2 != null && !string2.isEmpty()) {
                    return string2;
                }
            }
            catch (Exception exception) {
                bqc.DVW.hAB("Error: unable to determine macOS host name.");
            }
        } else if (ZjF.DVW()) {
            String string;
            try {
                string = InetAddress.getLocalHost().getHostName();
                if (string != null && !string.isEmpty()) {
                    return string;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            string = System.getenv("COMPUTERNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
        } else if (ZjF.hAB()) {
            String string = System.getenv("HOSTNAME");
            if (string != null && !string.isEmpty()) {
                return string;
            }
            try {
                String string3 = InetAddress.getLocalHost().getHostName();
                if (string3 != null && !string3.isEmpty()) {
                    return string3;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "localhost";
    }

    private static native String getNativeComputerName();

    public static UUID XHT() {
        if (XHT == null) {
            XHT = Platform.jJc();
        }
        assert (bqc.XHT(XHT != null));
        return XHT;
    }

    private static UUID jJc() {
        if (ZjF.DVW()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483646, "SOFTWARE\\Microsoft\\Cryptography", "MachineGuid");
            return UUID.fromString(string);
        }
        if (ZjF.gBO()) {
            String string = MacOsXIoKit.readRegistryStringValue("IOPlatformUUID");
            return UUID.fromString(string);
        }
        if (ZjF.hAB()) {
            try {
                byte[] byArray;
                byte[] byArray2 = new byte[]{117, -113, 37, -18, 20, 42, 106, -119, 115, 122, 126, 40, 55, 123, 38, 93, 22, 63, -21, -127, 68, 107, 5, 37, 9, 26, 109, 51, 40, -109, 35, 41};
                String string = NRE.DVW(byArray2);
                File file = null;
                File file2 = new File(string);
                if (file2.isFile()) {
                    file = file2;
                } else {
                    byArray = new byte[]{0, 39, 85, -46, 55, -14, -109, 17, 6, -63, 27, 5, 20, -94, -41, -60, 81, 50, -25, -111, 26, 45, 12};
                    String string2 = NRE.DVW(byArray);
                    file = new File(string2);
                }
                byArray = yhy.nrS(file);
                return UUID.nameUUIDFromBytes(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static void hAB() {
        Thread.currentThread().setPriority(4);
        if (ZjF.hAB()) {
            Platform.initThreadForBackgroundIONative();
        }
    }

    private static native void initThreadForBackgroundIONative();

    public static void DVW(File file) {
        bqc.DVW.gBO("Openning file with default application " + file.getPath());
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        if (ZjF.hAB()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file.getAbsolutePath());
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n4 = process.waitFor();
                if (n4 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n4);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (ZjF.gBO()) {
            ProcessBuilder processBuilder = file.isDirectory() ? new ProcessBuilder("open", "-R", file.getAbsolutePath()) : new ProcessBuilder("open", file.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n5 = process.waitFor();
                if (n5 != 0) {
                    throw new IOException("open " + file.getAbsolutePath() + " returned error exit code " + n5);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (ZjF.DVW() && !WindowsPlatform.DVW(file.getAbsolutePath())) {
            throw new IOException("Couldn't open file: " + file.getAbsolutePath());
        }
    }

    public static void gBO(File file) {
        File file2;
        for (file2 = file; file2 != null && !file2.exists(); file2 = file2.getParentFile()) {
        }
        if (file2 == null) {
            throw new FileNotFoundException();
        }
        if (ZjF.hAB()) {
            File file3 = yhy.pxg("nautilus");
            if (file3 != null) {
                ProcessBuilder processBuilder = new ProcessBuilder("nautilus", "-s", file.getAbsolutePath());
                processBuilder.environment().remove("LD_LIBRARY_PATH");
                Process process = processBuilder.start();
                try {
                    int n4 = process.waitFor();
                    if (n4 != 0) {
                        throw new IOException("nautilus returned error exit code " + n4);
                    }
                }
                catch (InterruptedException interruptedException) {}
            } else {
                File file4 = file2.isDirectory() ? file2 : file2.getParentFile();
                ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", file4.getAbsolutePath());
                processBuilder.environment().remove("LD_LIBRARY_PATH");
                Process process = processBuilder.start();
                try {
                    int n5 = process.waitFor();
                    if (n5 != 0) {
                        throw new IOException("xdg-open returned error exit code " + n5);
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        } else if (ZjF.gBO()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", "-R", file2.getAbsolutePath());
            Process process = processBuilder.start();
            try {
                int n6 = process.waitFor();
                if (n6 != 0) {
                    throw new IOException("open -R " + file2.getAbsolutePath() + " returned error exit code " + n6);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (ZjF.DVW() && !WindowsPlatform.gBO(file2.getAbsolutePath())) {
            throw new IOException("Couldn't explore file: " + file2.getAbsolutePath());
        }
    }

    public static void DVW(String string) {
        assert (bqc.DVW(string != null && !string.isEmpty()));
        if (ZjF.hAB()) {
            ProcessBuilder processBuilder = new ProcessBuilder("xdg-open", string);
            processBuilder.environment().remove("LD_LIBRARY_PATH");
            Process process = processBuilder.start();
            try {
                int n4 = process.waitFor();
                if (n4 != 0) {
                    throw new IOException("xdg-open returned error exit code " + n4);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (ZjF.gBO()) {
            ProcessBuilder processBuilder = new ProcessBuilder("open", string);
            Process process = processBuilder.start();
            try {
                int n5 = process.waitFor();
                if (n5 != 0) {
                    throw new IOException("open " + string + " returned error exit code " + n5);
                }
            }
            catch (InterruptedException interruptedException) {}
        } else if (ZjF.DVW() && !WindowsPlatform.DVW(string)) {
            throw new IOException("Couldn't open URL: " + string);
        }
    }

    public static String lTJ() {
        try {
            if (ZjF.hAB()) {
                return Platform.Mdo();
            }
            if (ZjF.DVW()) {
                return Platform.pxg();
            }
            if (ZjF.gBO()) {
                return Platform.fJ1();
            }
        }
        catch (Throwable throwable) {
            bqc.DVW.gBO(throwable);
        }
        return null;
    }

    private static String fJ1() {
        try {
            rZx rZx2 = GRo.DVW(new String[]{"sw_vers"}, null);
            if (rZx2.DVW() == 0) {
                String string = rZx2.gBO();
                return string;
            }
            return null;
        }
        catch (ProcessException processException) {
            return null;
        }
    }

    private static String pxg() {
        try {
            rZx rZx2 = GRo.DVW(new String[]{"systeminfo"}, null);
            if (rZx2.DVW() == 0) {
                String string = rZx2.gBO();
                return string;
            }
            bqc.DVW.lTJ("Error obtaining detailed OS info\nProcess returned exit code " + rZx2.DVW() + "\nOutput:\n" + rZx2.gBO() + "\n\nErrors:\n" + rZx2.XHT());
            return null;
        }
        catch (ProcessException processException) {
            bqc.DVW.lTJ("Error obtaining detailed OS info", processException);
            return null;
        }
    }

    private static String Mdo() {
        String string = Platform.iRw();
        String string2 = Platform.D2F();
        return string + "\n" + string2;
    }

    private static String iRw() {
        try {
            rZx rZx2 = GRo.DVW(new String[]{"lsb_release", "-a"}, null);
            if (rZx2.DVW() == 0) {
                String string = rZx2.gBO();
                return string;
            }
            return "";
        }
        catch (ProcessException processException) {
            return "";
        }
    }

    private static String D2F() {
        try {
            return Vfa.DVW(new FileReader(new File("/proc/cpuinfo")));
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static File qhn() {
        return lTJ;
    }

    public static File nrS() {
        return qhn;
    }

    public static native void simulateCrashInNativeCode();

    public static File gBO(String string) {
        if (ZjF.DVW()) {
            return Platform.qhn(string);
        }
        if (ZjF.gBO()) {
            return Platform.lTJ(string);
        }
        if (ZjF.hAB()) {
            return Platform.hAB(string);
        }
        assert (bqc.XHT(false));
        return null;
    }

    private static File hAB(String string) {
        String string2;
        File file = new File("/media/" + string);
        if (!(file.isDirectory() || (file = new File("/media/" + (string2 = System.getProperty("user.name")) + "/" + string)).isDirectory() || (file = new File("/mnt/" + string)).isDirectory() || (file = new File("/mnt/" + string2 + "/" + string)).isDirectory())) {
            return null;
        }
        return file;
    }

    private static File lTJ(String string) {
        File file = new File("/Volumes/" + string);
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    private static File qhn(String string) {
        File file;
        FileStore fileStore;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.type().equals("UDF") && !fileStore.type().equals("CDFS") || !fileStore.name().toLowerCase().startsWith(string.toLowerCase())) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                fileStore = Files.getFileStore(path);
                file = path.toFile();
                if (!fileStore.name().equalsIgnoreCase(string)) continue;
                return file;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    public static File XHT(String string) {
        if (ZjF.DVW()) {
            return Platform.jpF(string);
        }
        if (ZjF.gBO()) {
            return Platform.nrS(string);
        }
        if (ZjF.hAB()) {
            return Platform.jJc(string);
        }
        assert (bqc.XHT(false));
        return null;
    }

    private static File nrS(String string) {
        File file = new File("/Volumes");
        return Platform.DVW(file, string);
    }

    private static File DVW(File file, String string) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                File file3 = new File(file2, string);
                if (!file3.isDirectory()) continue;
                return file3;
            }
        }
        return null;
    }

    private static File jpF(String string) {
        File file;
        Object object;
        FileSystem fileSystem = FileSystems.getDefault();
        for (Path path : fileSystem.getRootDirectories()) {
            try {
                File file2;
                object = Files.getFileStore(path);
                file = path.toFile();
                if (!((FileStore)object).type().equals("UDF") && !((FileStore)object).type().equals("CDFS") || !(file2 = new File(file, string)).isDirectory()) continue;
                return file2;
            }
            catch (IOException iOException) {
            }
        }
        for (Path path : fileSystem.getRootDirectories()) {
            object = path.toFile();
            file = new File((File)object, string);
            if (!file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    private static File jJc(String string) {
        String string2 = System.getProperty("user.name");
        File file = Platform.DVW(new File("/media/" + string2), string);
        if (file == null && (file = Platform.DVW(new File("/media"), string)) == null && (file = Platform.DVW(new File("/mnt/" + string2), string)) == null) {
            file = Platform.DVW(new File("/mnt"), string);
        }
        return file;
    }

    public static native boolean supportsWindowsDpiAwareFunctionality();

    static {
        Platform.DVW();
        if (ZjF.DVW()) {
            String string = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "DESKTOP");
            lTJ = string != null && !string.isEmpty() ? new File(string) : new File(yhy.gBO(), "Desktop");
            String string2 = WindowsRegistry.readRegistryStringValue(-2147483647, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Personal");
            if (string2 != null && !string2.isEmpty()) {
                qhn = new File(string2);
            } else {
                lTJ = new File(yhy.gBO(), "Documents");
            }
        } else {
            lTJ = new File(yhy.gBO(), "Desktop");
            qhn = yhy.gBO();
        }
    }
}

