/*
 * Decompiled with CFR 0.152.
 */
package com.bitwig.base.extension.generator;

import com.bitwig.base.extension.generator.ControllerExtensionInfo;
import com.bitwig.base.extension.generator.wEG;
import javax.lang.model.SourceVersion;

public class JavaControllerExtensionInfo
extends ControllerExtensionInfo {
    private String mClassName;
    private String mPackageName;
    private String mGroupId;
    private String mArtifactId;

    @Override
    public void verify() {
        super.verify();
        this.notEmpty(this.mClassName, "Class Name");
        this.notEmpty(this.mPackageName, "Package Name");
        this.notEmpty(this.mGroupId, "Maven Group Id");
        this.notEmpty(this.mArtifactId, "Maven Artifact Id");
        if (!SourceVersion.isName(this.mClassName)) {
            throw new wEG(this.mClassName + " is not a valid Java identifier");
        }
        String string = this.mPackageName + "." + this.mClassName;
        if (!SourceVersion.isName(string)) {
            throw new wEG(string + " is not a valid fully qualified Java class name");
        }
    }

    public String getClassName() {
        return this.mClassName;
    }

    public void setClassName(String string) {
        this.mClassName = string;
    }

    public String getFullClassName() {
        return this.mPackageName + "." + this.mClassName;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public void setPackageName(String string) {
        this.mPackageName = string;
    }

    public String getGroupId() {
        return this.mGroupId;
    }

    public void setGroupId(String string) {
        this.mGroupId = string;
    }

    public String getArtifactId() {
        return this.mArtifactId;
    }

    public void setArtifactId(String string) {
        this.mArtifactId = string;
    }

    @Override
    protected String getTemplateName() {
        return "java-controller";
    }
}

