/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.controller.api.Application;
import com.bitwig.extension.controller.api.Clip;
import com.bitwig.extension.controller.api.ClipLauncherSlot;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Track;
import com.bitwig.extension.controller.api.TrackBank;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class ZT {
    private final OscAddressSpace DVW;
    private final ControllerHost gBO;
    private final Transport XHT;
    private final OscConnection hAB;
    private final MasterTrack lTJ;
    private final TrackBank qhn;
    private final TrackBank nrS;
    private final Application jpF;
    private final Clip jJc;
    private final Clip fJ1;
    private final CursorTrack pxg;

    public ZT(ControllerHost controllerHost) {
        this.gBO = controllerHost;
        this.jpF = controllerHost.createApplication();
        this.XHT = controllerHost.createTransport();
        this.XHT.tempo().markInterested();
        this.XHT.isMetronomeEnabled().markInterested();
        this.XHT.isMetronomeEnabled().addValueObserver(this::DVW);
        this.XHT.isPlaying().markInterested();
        this.XHT.isPlaying().addValueObserver(this::gBO);
        this.XHT.isArrangerRecordEnabled().markInterested();
        this.XHT.isArrangerRecordEnabled().addValueObserver(this::XHT);
        this.XHT.isClipLauncherOverdubEnabled().markInterested();
        this.XHT.isClipLauncherOverdubEnabled().addValueObserver(this::hAB);
        this.XHT.isClipLauncherAutomationWriteEnabled().markInterested();
        this.XHT.isClipLauncherAutomationWriteEnabled().addValueObserver(this::lTJ);
        this.XHT.isArrangerLoopEnabled().markInterested();
        this.XHT.isArrangerLoopEnabled().addValueObserver(this::qhn);
        this.pxg = this.gBO.createCursorTrack(0, 0);
        this.pxg.position().addValueObserver(n4 -> this.lTJ());
        this.pxg.trackType().markInterested();
        this.lTJ = this.gBO.createMasterTrack(100);
        this.qhn = this.gBO.createMainTrackBank(100, 20, 100);
        this.nrS = this.gBO.createEffectTrackBank(20, 100);
        this.qhn.itemCount().markInterested();
        this.qhn.sceneBank().itemCount().markInterested();
        this.nrS.itemCount().markInterested();
        for (int i2 = 0; i2 < this.qhn.getSizeOfBank(); ++i2) {
            int n5 = i2;
            Track track = (Track)this.qhn.getItemAt(i2);
            track.trackType().markInterested();
            track.mute().addValueObserver(bl2 -> this.DVW(track, n5));
            track.arm().addValueObserver(bl2 -> this.gBO(track, n5));
            track.solo().addValueObserver(bl2 -> this.XHT(track, n5));
            track.volume().value().addValueObserver(d3 -> this.hAB(track, n5));
            track.pan().value().addValueObserver(d3 -> this.lTJ(track, n5));
        }
        this.jJc = this.gBO.createArrangerCursorClip(1, 1);
        this.fJ1 = this.gBO.createLauncherCursorClip(1, 1);
        OscModule oscModule = this.gBO.getOscModule();
        this.DVW = oscModule.createAddressSpace();
        this.DVW.registerObjectMethods("/dawctrl", this);
        this.hAB = oscModule.connectToUdpServer("localhost", 7577, this.DVW);
        oscModule.createUdpServer(7578, this.DVW);
    }

    public void DVW() {
        this.nrS();
    }

    private int DVW(Track track) {
        String string;
        switch (string = track.trackType().get()) {
            case "Group": {
                return 3;
            }
            case "Instrument": {
                return 2;
            }
            case "Audio": {
                return 1;
            }
            case "Hybrid": {
                return 0;
            }
            case "Effect": {
                return 4;
            }
            case "Master": {
                return 5;
            }
        }
        return 0;
    }

    private void DVW(String string, Object ... objectArray) {
        try {
            this.hAB.sendMessage(string, objectArray);
        }
        catch (IOException iOException) {
            this.gBO.println("Error while sending OSC message to: " + string + "\n" + iOException.getMessage() + "\n");
        }
    }

    private void gBO() {
        this.hAB();
        this.lTJ();
        this.qhn();
        this.hAB(this.lTJ, 0);
        this.lTJ(this.lTJ, 0);
        this.lTJ(this.XHT.isClipLauncherAutomationWriteEnabled().get());
        this.qhn(this.XHT.isArrangerLoopEnabled().get());
        this.DVW(this.XHT.isMetronomeEnabled().get());
    }

    private void XHT() {
        this.DVW("/dawctrl/pong", new Object[0]);
    }

    private void DVW(boolean bl2) {
        this.DVW("/dawctrl/metronome", bl2 ? 1 : 0);
    }

    private void gBO(boolean bl2) {
        this.DVW("/dawctrl/play", bl2 ? 1 : 0);
    }

    private void XHT(boolean bl2) {
        this.DVW("/dawctrl/record", bl2 ? 1 : 0);
    }

    private void hAB(boolean bl2) {
        this.DVW("/dawctrl/session_record", bl2 ? 1 : 0);
    }

    private void lTJ(boolean bl2) {
        this.DVW("/dawctrl/session_automation_record", bl2 ? 1 : 0);
    }

    private void qhn(boolean bl2) {
        this.DVW("/dawctrl/loop", bl2 ? 1 : 0);
    }

    private void hAB() {
        this.DVW("/dawctrl/size", this.qhn.itemCount().get(), this.qhn.sceneBank().itemCount().get(), this.nrS.itemCount().get());
    }

    private void lTJ() {
        int n4 = this.pxg.position().get();
        int n5 = this.DVW(this.pxg);
        this.DVW("/dawctrl/track", n5, n4, "");
    }

    private void qhn() {
        this.DVW("/dawctrl/scene", 0, "");
    }

    private void DVW(Track track, int n4) {
        int n5 = this.DVW(track);
        boolean bl2 = track.mute().get();
        this.DVW("/dawctrl/track/mute", n5, n4, bl2 ? 1 : 0);
    }

    private void gBO(Track track, int n4) {
        int n5 = this.DVW(track);
        boolean bl2 = track.arm().get();
        this.DVW("/dawctrl/track/arm", n5, n4, bl2 ? 1 : 0);
    }

    private void XHT(Track track, int n4) {
        int n5 = this.DVW(track);
        boolean bl2 = track.solo().get();
        this.DVW("/dawctrl/track/solo", n5, n4, bl2 ? 1 : 0);
    }

    private void hAB(Track track, int n4) {
        int n5 = this.DVW(track);
        float f2 = (float)track.volume().get();
        this.DVW("/dawctrl/track/solo", n5, n4, Float.valueOf(f2));
    }

    private void lTJ(Track track, int n4) {
        int n5 = this.DVW(track);
        float f2 = (float)track.pan().get();
        this.DVW("/dawctrl/track/pan", n5, n4, Float.valueOf(f2));
    }

    private void nrS() {
        this.DVW("/dawctrl/shutdown", new Object[0]);
    }

    @OscMethod(address="/init")
    public void handleInit() {
        this.gBO();
    }

    @OscMethod(address="/ping")
    public void handlePing() {
        this.XHT();
    }

    @OscMethod(address="/stop/all_clips")
    public void handleStopAllClips() {
        this.lTJ.stop();
    }

    @OscMethod(address="/stop/track")
    public void handleStopTrack(int n4) {
        this.qhn.getChannel(n4).stop();
    }

    @OscMethod(address="/play/scene")
    public void handlePlayScene(int n4) {
        ((ClipLauncherSlot)this.lTJ.clipLauncherSlotBank().getItemAt(n4)).launch();
    }

    @OscMethod(address="/play/clip")
    public void handlePlayClip(int n4, int n5) {
        ((ClipLauncherSlot)this.qhn.getChannel(n4).clipLauncherSlotBank().getItemAt(n5)).launch();
    }

    @OscMethod(address="/stop/clip")
    public void handleStopClip(int n4, int n5) {
        this.qhn.getChannel(n4).stop();
    }

    @OscMethod(address="/undo")
    public void handleUndo() {
        this.jpF.undo();
    }

    @OscMethod(address="/redo")
    public void handleRedo() {
        this.jpF.redo();
    }

    @OscMethod(address="/loop")
    public void handleLoop(int n4) {
        this.XHT.isArrangerLoopEnabled().set(n4 != 0);
    }

    @OscMethod(address="/play")
    public void handlePlay() {
        this.XHT.play();
    }

    @OscMethod(address="/record")
    public void handleRecord(int n4) {
        this.XHT.isArrangerRecordEnabled().set(n4 != 0);
    }

    @OscMethod(address="/session_record")
    public void handleSessionRecord(int n4) {
        this.XHT.isClipLauncherOverdubEnabled().set(n4 != 0);
        this.XHT.isClipLauncherAutomationWriteEnabled().set(n4 != 0);
    }

    @OscMethod(address="/metronome")
    public void handleMetronome(int n4) {
        this.XHT.isMetronomeEnabled().set(n4 != 0);
    }

    @OscMethod(address="/stop")
    public void handleStop() {
        this.XHT.stop();
    }

    @OscMethod(address="/scrub")
    public void handleScrub(float f2) {
    }

    @OscMethod(address="/automation")
    public void handleAutomation(int n4) {
        this.XHT.isArrangerAutomationWriteEnabled().set(n4 != 0);
    }

    private Track DVW(int n4, int n5) {
        switch (n4) {
            case 0: {
                return this.qhn.getChannel(n5);
            }
            case 1: {
                return this.qhn.getChannel(n5);
            }
            case 2: {
                return this.qhn.getChannel(n5);
            }
            case 3: {
                return this.qhn.getChannel(n5);
            }
            case 4: {
                return this.nrS.getChannel(n5);
            }
            case 5: {
                return this.lTJ;
            }
            case 6: {
                return this.qhn.getChannel(n5);
            }
        }
        this.gBO.println("Received invalid track type: " + n4);
        return null;
    }

    @OscMethod(address="/track/arm")
    public void handleTrackArm(int n4, int n5, int n6) {
        this.DVW(n4, n5).getArm().set(n6 != 0);
    }

    @OscMethod(address="/track/mute")
    public void handleTrackMute(int n4, int n5, int n6) {
        this.DVW(n4, n5).getMute().set(n6 != 0);
    }

    @OscMethod(address="/track/solo")
    public void handleTrackSolo(int n4, int n5, int n6) {
        this.DVW(n4, n5).getSolo().set(n6 != 0);
    }

    @OscMethod(address="/track/volume")
    public void handleTrackVolume(int n4, int n5, float f2) {
        this.DVW(n4, n5).getVolume().set(f2);
    }

    @OscMethod(address="/track/pan")
    public void handleTrackPan(int n4, int n5, float f2) {
        this.DVW(n4, n5).getPan().set(f2);
    }

    @OscMethod(address="/tap_tempo")
    public void handleTapTempo() {
        this.XHT.tapTempo();
    }

    @OscMethod(address="/clip/quantize")
    public void handleClipQuantize() {
        this.jJc.quantize(1.0);
        this.fJ1.quantize(1.0);
    }

    @OscMethod(address="/scene/view")
    public void handleSceneView() {
    }

    @OscMethod(address="/track/view")
    public void handleTrackView() {
    }

    @OscMethod(address="/midi_arm_exclusive")
    public void handleMidiArmExclusive() {
        this.pxg.getArm().set(true);
    }

    @OscMethod(address="/track/info")
    public void handleTrackInfo() {
    }
}

