/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.opensoundcontrol.OscAddressSpace;
import com.bitwig.extension.api.opensoundcontrol.OscConnection;
import com.bitwig.extension.api.opensoundcontrol.OscMessage;
import com.bitwig.extension.api.opensoundcontrol.OscMethod;
import com.bitwig.extension.api.opensoundcontrol.OscModule;
import com.bitwig.extension.api.opensoundcontrol.OscServer;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ChainSelector;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorDevice;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.DeviceLayer;
import com.bitwig.extension.controller.api.IntegerValue;
import com.bitwig.extension.controller.api.MasterTrack;
import com.bitwig.extension.controller.api.Preferences;
import com.bitwig.extension.controller.api.SettableIntegerValue;
import com.bitwig.extension.controller.api.SettableRangedValue;
import com.bitwig.extension.controller.api.Transport;
import java.io.IOException;

public class GVp
extends ControllerExtension {
    private Transport DVW;
    private MasterTrack gBO;
    private CursorTrack XHT;
    private CursorDevice hAB;
    private ChainSelector lTJ;
    private DeviceLayer qhn;
    private SettableIntegerValue nrS;
    private IntegerValue jpF;
    private OscServer jJc;

    public GVp(VBq vBq, ControllerHost controllerHost) {
        super(vBq, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        Preferences preferences = controllerHost.getPreferences();
        SettableRangedValue settableRangedValue = preferences.getNumberSetting("port", "Server", 1024.0, 32000.0, 1.0, "", 9001.0);
        settableRangedValue.addRawValueObserver(this::DVW);
        this.DVW = controllerHost.createTransport();
        this.gBO = controllerHost.createMasterTrack(1);
        this.XHT = controllerHost.createCursorTrack("osc-cursor-track", "OSC cursor track", 1, 1, true);
        this.hAB = this.XHT.createCursorDevice();
        this.lTJ = this.hAB.createChainSelector();
        this.qhn = this.lTJ.activeChain();
        this.nrS = this.lTJ.activeChainIndex();
        this.jpF = this.lTJ.chainCount();
        this.qhn.name().markInterested();
        this.jpF.markInterested();
        this.nrS.markInterested();
        this.DVW();
    }

    private void DVW(double d3) {
        int n4 = (int)d3;
        try {
            this.jJc.start(n4);
        }
        catch (IOException iOException) {
            ((ControllerHost)this.getHost()).showPopupNotification("Could not set the OSC port to " + n4 + ": " + iOException.getMessage());
        }
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void DVW() {
        OscModule oscModule = ((ControllerHost)this.getHost()).getOscModule();
        OscAddressSpace oscAddressSpace = oscModule.createAddressSpace();
        oscAddressSpace.setName("bitwig");
        oscAddressSpace.registerObjectMethods("/bitwig/transport", this.DVW);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorDevice", this.hAB);
        oscAddressSpace.registerObjectMethods("/bitwig/cursorTrack", this.XHT);
        oscAddressSpace.registerObjectMethods("/bitwig/masterTrack", this.gBO);
        oscAddressSpace.registerObjectMethods("/bitwig/", this);
        oscAddressSpace.registerDefaultMethod(this::DVW);
        oscAddressSpace.setShouldLogMessages(true);
        this.jJc = oscModule.createUdpServer(oscAddressSpace);
    }

    private void DVW(OscConnection oscConnection, OscMessage oscMessage) {
        ((ControllerHost)this.getHost()).println("OSC method not found for " + oscMessage.getAddressPattern() + "(" + oscMessage.getTypeTag() + ")");
    }

    @OscMethod(address="/test/int")
    public void handleTestInt(int n4) {
        ((ControllerHost)this.getHost()).println("int value: " + n4);
    }

    @OscMethod(address="/test/long")
    public void handleTestLong(long l2) {
        ((ControllerHost)this.getHost()).println("long value: " + l2);
    }

    @OscMethod(address="/test/float")
    public void handleTestFloat(float f2) {
        ((ControllerHost)this.getHost()).println("float value: " + f2);
    }

    @OscMethod(address="/test/double")
    public void handleTestDouble(double d3) {
        ((ControllerHost)this.getHost()).println("double value: " + d3);
    }

    @OscMethod(address="/test/bool")
    public void handleTestBool(boolean bl2) {
        ((ControllerHost)this.getHost()).println("boolean value: " + bl2);
    }

    @OscMethod(address="/test/string")
    public void handleTestString(String string) {
        ((ControllerHost)this.getHost()).println("string value: " + string);
    }

    @OscMethod(address="/test/ping")
    public void handleTestPing(OscConnection oscConnection) {
        oscConnection.sendMessage("/test/pong", new Object[0]);
    }

    @OscMethod(address="/test/chain-selector/select-next")
    public void handleChainSelectorNext() {
        this.lTJ.selectNext();
    }

    @OscMethod(address="/test/chain-selector/select-prev")
    public void handleChainSelectorPrev() {
        this.lTJ.selectPrevious();
    }

    @OscMethod(address="/test/chain-selector/select-first")
    public void handleChainSelectorFirst() {
        this.lTJ.selectFirst();
    }

    @OscMethod(address="/test/chain-selector/select-last")
    public void handleChainSelectorLast() {
        this.lTJ.selectLast();
    }

    @OscMethod(address="/test/chain-selector/cycle-next")
    public void handleChainSelectorCycleNext() {
        this.lTJ.cycleNext();
    }

    @OscMethod(address="/test/chain-selector/cycle-prev")
    public void handleChainSelectorCyclePrev() {
        this.lTJ.cyclePrevious();
    }

    @OscMethod(address="/test/chain-selector/test-active-chain")
    public void handleChainSelectorTestActiveChain() {
        ((ControllerHost)this.getHost()).println("ChainSelectorIndex: " + this.nrS.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorChainCount: " + this.jpF.get());
        ((ControllerHost)this.getHost()).println("ChainSelectorActiveChainName: " + this.qhn.name().get());
    }
}

