/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.api.util.midi.ShortMidiMessage;
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.CursorRemoteControlsPage;
import com.bitwig.extension.controller.api.CursorTrack;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.NoteInput;
import com.bitwig.extension.controller.api.PinnableCursorDevice;
import com.bitwig.extension.controller.api.RemoteControl;
import com.bitwig.extension.controller.api.Transport;
import com.bitwig.extension.controller.api.UserControlBank;

public class EVh
extends ControllerExtension {
    private Transport DVW;
    private CursorTrack gBO;
    private PinnableCursorDevice XHT;
    private CursorRemoteControlsPage hAB;
    private MidiIn lTJ;
    private UserControlBank qhn;

    protected EVh(lSN lSN2, ControllerHost controllerHost) {
        super(lSN2, controllerHost);
    }

    @Override
    public void init() {
        int n4;
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        this.lTJ = controllerHost.getMidiInPort(0);
        this.lTJ.setMidiCallback(shortMidiMessage -> this.DVW(shortMidiMessage));
        this.lTJ.setSysexCallback(string -> this.DVW(string));
        NoteInput noteInput = this.lTJ.createNoteInput("All Channels", "??????");
        noteInput.setShouldConsumeEvents(false);
        for (n4 = 0; n4 < 16; ++n4) {
            this.lTJ.createNoteInput("Channel " + (n4 + 1), "?" + Integer.toHexString(n4) + "????");
        }
        this.DVW = controllerHost.createTransport();
        this.gBO = controllerHost.createCursorTrack(3, 0);
        this.XHT = this.gBO.createCursorDevice();
        this.hAB = this.XHT.createCursorRemoteControlsPage(8);
        for (n4 = 0; n4 < 8; ++n4) {
            RemoteControl remoteControl = this.hAB.getParameter(n4);
            remoteControl.setIndication(true);
            remoteControl.setLabel("P" + (n4 + 1));
        }
        this.qhn = controllerHost.createUserControls(111);
        for (n4 = 1; n4 < 119; ++n4) {
            if (EVh.DVW(n4)) continue;
            int n5 = EVh.gBO(n4);
            this.qhn.getControl(n5).setLabel("CC" + n4);
        }
    }

    private static boolean DVW(int n4) {
        return n4 >= 20 && n4 <= 27;
    }

    private static int gBO(int n4) {
        if (n4 > 27) {
            return n4 - 1 - 8;
        }
        return n4 - 1;
    }

    @Override
    public void exit() {
    }

    @Override
    public void flush() {
    }

    private void DVW(ShortMidiMessage shortMidiMessage) {
        if (shortMidiMessage.isControlChange()) {
            int n4 = shortMidiMessage.getData1();
            if (EVh.DVW(n4)) {
                int n5 = n4 - 20;
                this.hAB.getParameter(n5).value().set(shortMidiMessage.getData2(), 128);
            } else if (n4 >= 1 && n4 <= 119) {
                int n6 = EVh.gBO(n4);
                this.qhn.getControl(n6).value().set(shortMidiMessage.getData2(), 128);
            }
        }
    }

    private void DVW(String string) {
        if (string.equals("f07f7f0605f7")) {
            this.DVW.rewind();
        } else if (string.equals("f07f7f0604f7")) {
            this.DVW.fastForward();
        } else if (string.equals("f07f7f0601f7")) {
            this.DVW.stop();
        } else if (string.equals("f07f7f0602f7")) {
            this.DVW.play();
        } else if (string.equals("f07f7f0606f7")) {
            this.DVW.record();
        }
    }
}

