/*
 * Decompiled with CFR 0.152.
 */
import com.bitwig.extension.controller.ControllerExtension;
import com.bitwig.extension.controller.api.ControllerHost;
import com.bitwig.extension.controller.api.MidiIn;
import com.bitwig.extension.controller.api.MidiOut;
import com.bitwig.extension.controller.api.NoteInput;

public class CN
extends ControllerExtension {
    private NoteInput DVW;
    private int gBO;
    private int XHT;
    private int hAB;
    private int lTJ;
    private boolean qhn;
    private int nrS;
    private int jpF;
    private int jJc;
    private double fJ1;

    public CN(XME xME, ControllerHost controllerHost) {
        super(xME, controllerHost);
    }

    @Override
    public void init() {
        ControllerHost controllerHost = (ControllerHost)this.getHost();
        MidiIn midiIn = controllerHost.getMidiInPort(1);
        this.DVW = midiIn.createNoteInput("Notes", new String[0]);
        MidiIn midiIn2 = controllerHost.getMidiInPort(0);
        midiIn2.setMidiCallback(this::DVW);
        MidiOut midiOut = this.getMidiOutPort(0);
        controllerHost.scheduleTask(this::DVW, this.gBO());
    }

    void DVW() {
        double d3 = (double)this.hAB * 6.103888176768602E-5;
        double d4 = 4096.0;
        double d5 = Math.max(-4096.0, Math.min(4096.0, (double)(8192 - this.gBO)));
        double d6 = (double)(this.XHT - 8192) + d5;
        double d7 = 2000.0 + d3 * 5000.0;
        this.fJ1 = Math.max(this.fJ1 - d7, Math.min(this.fJ1 + d7, this.qhn ? d6 : 0.0));
        int n4 = (int)Math.abs(d6);
        this.gBO = Math.max(this.gBO - n4, Math.min(this.gBO + n4, 8192));
        int n5 = Math.max(0, Math.min(16383, (int)this.fJ1 + 8192));
        if (n5 != this.nrS) {
            this.DVW.sendRawMidiEvent(224, n5 & 0x7F, n5 >> 7);
        }
        if (this.hAB >> 7 != this.jpF) {
            this.DVW.sendRawMidiEvent(176, 2, this.hAB >> 7);
        }
        if (this.lTJ >> 7 != this.jJc) {
            this.DVW.sendRawMidiEvent(176, 1, this.lTJ >> 7);
        }
        ((ControllerHost)this.getHost()).scheduleTask(this::DVW, this.gBO());
        this.nrS = n5;
        this.jpF = this.hAB >> 7;
        this.jJc = this.lTJ >> 7;
    }

    private long gBO() {
        return 10L;
    }

    private void DVW(int n4, int n5, int n6) {
        if (n4 == 144) {
            this.gBO = -1;
            this.qhn = true;
        } else if (n4 == 128) {
            this.qhn = false;
        } else if (n4 == 224) {
            this.XHT = n6 << 7 | n5;
            if (this.gBO == -1) {
                this.gBO = this.XHT;
            }
        } else if (n4 == 176 && n5 == 1) {
            this.hAB = this.hAB & 0x7F | n6 << 7;
        } else if (n4 == 176 && n5 == 33) {
            this.hAB = this.hAB & 0x3F80 | n6;
        } else if (n4 == 176 && n5 == 2) {
            this.lTJ = this.lTJ & 0x7F | n6 << 7;
        } else if (n4 == 176 && n5 == 34) {
            this.lTJ = this.lTJ & 0x3F80 | n6;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void exit() {
    }
}

