/* Prints the signal hierarchy to std output. */
#include <stdio.h>
#include "mti.h"

static char msg_buf[200];

static dump_design()
{
	dump_region(mti_GetTopRegion(), 0);
}

/* initialization function */
dump_design_init(reg, generics, ports, param)
	regionID reg;
	interface_list *generics;
	interface_list *ports;
	char *param;
{
	mti_AddLoadDoneCB(dump_design, NULL);
}

static dump_region(reg, margin)
	regionID reg;
	int margin;
{
	char *name;
	signalID sig;

	if (!reg)
		return;
	name = mti_GetRegionName(reg);
	sprintf(msg_buf, "%*sRegion: %s\n", margin, " ", name);
	mti_PrintMessage(msg_buf);
	margin += 4;

	/* Print the signals in this region */
	sig = mti_FirstSignal(reg);
	while (sig) {
		dump_signal(sig, margin);
		sig = mti_NextSignal();
	}

	/* Do the lower level regions */
	reg = mti_FirstLowerRegion(reg);
	while (reg) {
		dump_region(reg, margin);
		reg = mti_NextRegion(reg);
	}
}

static dump_signal(sig, margin)
	signalID sig;
	int margin;
{
	char *name;

	name = mti_GetSignalName(sig);
	sprintf(msg_buf, "%*sSignal %s : ", margin, " ", name);
	switch (mti_GetSignalMode(sig)) {
		case MTI_INTERNAL:
			break;
		case MTI_DIR_IN:
			strcat(msg_buf, "IN ");
			break;
		case MTI_DIR_OUT:
			strcat(msg_buf, "OUT ");
			break;
		case MTI_DIR_INOUT:
			strcat(msg_buf, "INOUT ");
			break;
		default:
			strcat(msg_buf, "?MODE? ");
	}
	dump_type(mti_GetSignalType(sig));
	strcat(msg_buf, "\n");
	mti_PrintMessage(msg_buf);
}

static dump_type(type)
	typeID type;
{
	char **enum_vals;
	char tmp_buf[200];
	long left, right;
	long i;
	int kind;

	switch (kind = mti_GetTypeKind(type)) {
		case MTI_TYPE_ARRAY:
			left = mti_TickLeft(type);
			right = mti_TickRight(type);
			sprintf(tmp_buf, "Array(%d to %d) of ", left, right);
			strcat(msg_buf, tmp_buf);
			dump_type(mti_ElementType(type));
			break;
		case MTI_TYPE_ENUM:
			strcat(msg_buf, "(");
			enum_vals = mti_GetEnumValues(type);
			right = mti_TickRight(type);
			for (i = 0; i <= right; i++) {
				strcat(msg_buf, enum_vals[i]);
				if (i != right) 
					strcat(msg_buf, ", ");
			}
			strcat(msg_buf, ")");
			break;
		case MTI_TYPE_SCALAR:
		case MTI_TYPE_INTEGER:
			strcat(msg_buf, "Integer");
			break;
		case MTI_TYPE_REAL:
			strcat(msg_buf, "Real");
			break;
		case MTI_TYPE_TIME:
			strcat(msg_buf, "Time");
			break;
		default:
			sprintf(tmp_buf, "Unknown type: %d", kind);
			strcat(msg_buf, tmp_buf);
	}
}
