/************  C interface definitions   *****************
 *
 * Copyright 1993 Model Technology Incorporated
 * All rights reserved
 * $Revision: 1.7 $
 */

#ifndef MTI_BUILD
typedef void *regionID;
typedef void *signalID;
typedef void *varID;
typedef void *driverID;
typedef void *typeID;
typedef void *processID;
#endif
typedef long  DELAY;

typedef enum {
	MTI_TYPE_SCALAR,
	MTI_TYPE_ARRAY,
	MTI_TYPE_RECORD,
	MTI_TYPE_ENUM,
	MTI_TYPE_INTEGER,  /* not used (use MTI_TYPE_SCALAR instead) */
	MTI_TYPE_PHYSICAL, /* not used (use MTI_TYPE_SCALAR instead) */
	MTI_TYPE_REAL,
	MTI_TYPE_ACCESS,
	MTI_TYPE_FILE,
	MTI_TYPE_TIME
} type_kind;

typedef enum {
	MTI_INTERNAL,
	MTI_DIR_IN,
	MTI_DIR_OUT,
	MTI_DIR_INOUT
} dir_enum;

typedef enum {
	 MTI_ACTIVE,
	 MTI_EVENT
} process_trigger_enum;

typedef enum {
	MTI_INERTIAL,
	MTI_TRANSPORT
} driver_mode_enum;

typedef struct {
	unsigned long lo;
	long hi;
} time64;

typedef struct interface_list_tag {
	char *name;
	typeID type;
	dir_enum port_dir;
	union {
		long	  generic_value;
		double	  generic_value_real;
		time64	  generic_value_time;
		void	 *generic_array_value;
		signalID  port;
	} u;
	struct interface_list_tag *nxt;
} interface_list;

typedef void (*funcptr)();
typedef void *componentID;


/************* Functions *****************/
#ifndef PROTO 
# define PROTO(arg) ()
#endif

signalID mti_CreateSignal PROTO((char *name,
							   regionID region,
							   typeID type));

processID mti_CreateProcess PROTO((char *name,
								funcptr func,
								void *param));

driverID mti_CreateDriver PROTO((signalID sig));
void     mti_SetDriverOwner PROTO(( driverID driverid, processID processid));

driverID *mti_GetDriverSubelements PROTO((driverID driv, driverID *buf));
signalID *mti_GetSignalSubelements PROTO((signalID sig,  signalID *buf));
void	*mti_GetArraySignalValue  PROTO((signalID sig,  void     *buf));
void	*mti_GetArrayVarValue  PROTO((varID var,  void     *buf));

void	 mti_Sensitize PROTO((processID proc,
					  signalID sig,
					  process_trigger_enum when));
void	 mti_Desensitize PROTO((processID proc));

void	 mti_ScheduleDriver PROTO((driverID driver,
								long value,
								DELAY delay,
								driver_mode_enum mode));
void	 mti_ScheduleWakeup PROTO((processID process,
								DELAY delay));

long     mti_GetSignalValue PROTO((signalID sig));
long     mti_GetVarValue PROTO((varID var));
char	*mti_GetSignalName PROTO((signalID sig));
dir_enum mti_GetSignalMode PROTO((signalID sig));
typeID   mti_GetSignalType PROTO((signalID sig));
typeID   mti_GetVarType PROTO((varID var));

void     mti_PrintMessage PROTO((char *msg));
long     mti_Now PROTO((void));
long     mti_NowUpper PROTO((void));
time64	*mti_NowIndirect PROTO((time64 *));
char	*mti_Resolution PROTO((void));
unsigned long mti_Delta PROTO((void));

signalID mti_FindPort PROTO((interface_list *list, char *name));

void	 mti_AddInputReadyCB PROTO((int fd, funcptr func, void *param));

void     mti_AddEnvCB PROTO((funcptr func, void *param));
void	 mti_AddLoadDoneCB PROTO((funcptr func, void *param));
void     mti_AddQuitCB PROTO((funcptr func, void *param));
void	 mti_AddRestartCB PROTO((funcptr func, void *param));
void     mti_AddRestoreCB PROTO((funcptr func, void *param));
void     mti_AddSaveCB PROTO((funcptr func, void *param));
void	 mti_AddSimStatusCB PROTO((funcptr func, void *param));

void     mti_RemoveEnvCB PROTO((funcptr func, void *param));
void     mti_RemoveLoadDoneCB PROTO((funcptr func, void *param));
void     mti_RemoveQuitCB PROTO((funcptr func, void *param));
void     mti_RemoveRestartCB PROTO((funcptr func, void *param));
void     mti_RemoveRestoreCB PROTO((funcptr func, void *param));
void     mti_RemoveSaveCB PROTO((funcptr func, void *param));
void     mti_RemoveSimStatusCB PROTO((funcptr func, void *param));

regionID mti_GetTopRegion PROTO((void));
regionID mti_FirstLowerRegion PROTO((regionID reg));
regionID mti_NextRegion PROTO((regionID reg));
regionID mti_HigherRegion PROTO((regionID reg));
char	*mti_GetRegionName PROTO((regionID reg));
char	*mti_GetRegionFullName PROTO((regionID reg));
signalID mti_FirstSignal PROTO((regionID reg));
signalID mti_NextSignal PROTO((void));


char   **mti_GetEnumValues PROTO((typeID type));
typeID   mti_ElementType PROTO((typeID type));
type_kind mti_GetTypeKind PROTO((typeID type));
long     mti_TickRight PROTO((typeID type));
long     mti_TickLeft PROTO((typeID type));
long     mti_TickLength PROTO((typeID type));
long     mti_TickDir PROTO((typeID type));

typeID	 mti_CreateScalarType PROTO((long left, long right));
typeID	 mti_CreateEnumType PROTO((long size, long count, char **vals));
typeID	 mti_CreateArrayType PROTO((long left, long right, typeID elem_type));

signalID mti_FindSignal PROTO((char *nm));
varID    mti_FindVar PROTO((char *nm));
driverID mti_FindDriver PROTO((signalID sig));
void	*mti_GetVarAddr PROTO((char *nm));
void     mti_SetSignalValue PROTO((signalID sig, long val));
void     mti_SetVarValue PROTO((varID var, long val));
void     mti_Command PROTO((char *cmd));
void     mti_AddCommand PROTO((char *cmd_name, funcptr func));
int      mti_FatalError PROTO((void));
void     mti_AddQuitCB PROTO(( funcptr func, void *param));
void     mti_Break PROTO((void));
regionID mti_FindRegion PROTO((char *nm));
regionID mti_CreateRegion PROTO((regionID reg, char *nm));
char	*mti_FindProjectEntry PROTO((char *section, char *nm, int expand));
char	*mti_SignalImage PROTO((signalID sig));

regionID mti_GetCurrentRegion PROTO((void));
char	*mti_GetRegionSourceName PROTO((regionID reg));
void     mti_AddEnvCB PROTO((funcptr func, void *param)); 
char	*mti_GetVarImage PROTO((char *nm));
char	*mti_Image PROTO((void *ptr, typeID type));
int      mti_IsFirstInit PROTO((void));
int      mti_GetNextEventTime PROTO((time64 *timep));
int      mti_GetNextNextEventTime PROTO((time64 *timep));

char    *mti_GetLibraryName PROTO((regionID reg)); 
char    *mti_GetPrimaryName PROTO((regionID reg)); 
char    *mti_GetSecondaryName PROTO((regionID reg)); 

#define mti_GetSignalValueIndirect(sig, val) mti_GetArraySignalValue(sig, val)
#define mti_GetVarValueIndirect(sig, val) mti_GetArrayVarValue(sig, val)

int 	 mti_IsRestore PROTO((void));
int 	 mti_IsColdRestore PROTO((void));
void 	 mti_SaveChar PROTO((int data));
void 	 mti_SaveShort PROTO((int data));
void 	 mti_SaveLong PROTO((long data));
void     mti_SaveString PROTO((char *data));
void     mti_SaveBlock PROTO((char *data, long size));
char 	 mti_RestoreChar PROTO((void));
short 	 mti_RestoreShort PROTO((void));
long 	 mti_RestoreLong PROTO((void));
char    *mti_RestoreString PROTO((void));
void     mti_RestoreBlock PROTO((char *data));
void 	 mti_RestoreProcess PROTO((processID proc, char *name, funcptr func, void *param));

void 	*mti_Malloc PROTO((unsigned long size));
void 	 mti_Free PROTO((void *p));
void 	*mti_Realloc PROTO((void *p, unsigned long sz));


void	mti_WriteProjectEntry PROTO((char *key, char *val));
