//
// Execute V-System commands from the DOS command line
//
#include    <stdio.h>
#include 	<stdlib.h>
#include    <malloc.h>
#include    <string.h>
#include    <time.h>

#define INPUT_FILE "/vsystem.cmd"
#define OUTPUT_FILE "/vsystem.out"
#define YIELD { _asm mov ax, 1680H\
		_asm int     2FH }
#define TIMEOUT 10.0

static char buf[1024];

main (argc, argv, envp)
	int argc;
	char **argv;
	char **envp;
{
	char *windir;
	char *tmpdir;
	time_t start;
	time_t now;
	char *tmp;
	char cmd_file[256];
	char result_file[256];
	char cmd[256];
	FILE *fp;
	int c;

	//
	// Make sure we're in a DOS box
	//
	windir = getenv("windir");
	if (windir == NULL) {
		printf("This program must be run in a Windows DOS box.\n");
		return 1;
	}

	//
	// Get the names of the mailbox files
	//
	tmp = getenv("TMP");
	if (!tmp)
		tmp = getenv("TEMP");    // if TMP not set try TEMP
	if (tmp) {
		strcpy(cmd_file, tmp);
		strcpy(result_file, tmp);
	} else {
		strcpy(cmd_file, "");	 // if no env set then use root dir
		strcpy(result_file, "");
	}
	strcat(cmd_file, INPUT_FILE);
	strcat(result_file, OUTPUT_FILE);

	//
	// create the output file to block V-System from executing cmd file
	//
	fp = fopen(result_file, "w");
	if (fp) {
		fputs("busy", fp);
		fclose(fp);
	} else {
		perror(result_file);
	} 

	//
	// Copy the command line to the cmd file
	//
	fp = fopen(cmd_file, "w");
	if (fp == NULL) {
		perror(cmd_file);
		return -1;
	}
	while (*(++argv)) {
		fputs(*argv, fp);
		fputs(" ", fp);
	}
	fclose(fp);

	//
	// Delete the output file so that V-System can read the cmd file
	//
	if (unlink(result_file) != 0) {
		perror(result_file);
	}

	//
	// wait up to 10 seconds for the output file to get created
	//
	time(&start);
	while (1) {
		YIELD
		if (access(result_file, 0) == 0)
			break;
		time(&now);
		if (difftime(now, start) > TIMEOUT) {
			printf("V-System is not running or is busy.\n");
			return -1;
		}
	}


	//
	// Wait for the command file to go away
	//
	do {
		YIELD
	} while (access(cmd_file, 0) == 0);


	//
	// copy the result file to stdout
	//
	fp = fopen(result_file, "r");
	if (fp != NULL) {
		/* Throw away first line */
		fgets(buf, sizeof(buf), fp);

		while (fgets(buf, sizeof(buf), fp) != NULL) {
		    if (buf[0] == '#')
			fputs(buf + 2, stdout);
		    else fputs(buf, stdout);
		}
		fclose(fp);
	}
	return 0;
}
