/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.atusbhid;

import com.atmel.atusbhid.AtUsbHidPanelButton;
import com.atmel.atusbhid.AtUsbHidPanelLed;
import com.atmel.atusbhidjni.AtUsbHidJni;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class AtUsbHidGui
implements Runnable {
    private AtUsbHidJni usbDevice = null;
    private JFrame jFrame = null;
    private AtUsbHidPanelButton jPanelButton = null;
    private JPanel jContentPane = null;
    private JPanel jPanelText = null;
    private AtUsbHidPanelLed jPanelLed = null;
    private JScrollPane jScrollPane = null;
    private JTextArea jTextArea = null;
    private JPanel jPanelStatus = null;
    private JLabel jLabelStatus = null;
    private boolean deviceConnected = false;
    private boolean autoConnect = false;
    private JLabel jLabelBufferInfo = null;

    public AtUsbHidGui() {
        String string = System.getProperty("user.dir") + "\\AtUsbHidJni";
        try {
            this.usbDevice = new AtUsbHidJni();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("AtUsbHid.AtUsbHid():UnsatisfiedLinkError");
            JOptionPane.showMessageDialog(null, "AtUsbHid.AtUsbHid():UnsatisfiedLinkError\nCan't find " + string + ".dll", "AtUsbHidJni.java error", 0);
            System.exit(0);
        }
        catch (SecurityException securityException) {
            JOptionPane.showMessageDialog(null, "AtUsbHid.AtUsbHid():SecurityException", "AtUsbHidJni.java error", 0);
            System.exit(0);
        }
        catch (NullPointerException nullPointerException) {
            JOptionPane.showMessageDialog(null, "AtUsbHid.AtUsbHid():NullPointerException", "AtUsbHidJni.java error", 0);
            System.err.println("AtUsbHid.AtUsbHid():NullPointerException");
            System.exit(0);
        }
        if (!this.usbDevice.loadLibraryUsbHid()) {
            JOptionPane.showMessageDialog(null, "DemoAtUsbHid.main():LoadLibrary", "AtUsbHidGui.java error", 0);
            System.exit(0);
        }
    }

    @Override
    public void run() {
        this.getJFrame().pack();
        this.getJFrame().setVisible(true);
    }

    private JFrame getJFrame() {
        if (this.jFrame == null) {
            this.jFrame = new JFrame();
            this.jFrame.setSize(new Dimension(510, 280));
            this.jFrame.setResizable(false);
            this.jFrame.setTitle("AtHidDll Jni demo code");
            this.jFrame.setContentPane(this.getJContentPane());
            this.jFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    if (AtUsbHidGui.this.deviceConnected) {
                        AtUsbHidGui.this.setDeviceConnected(false);
                    }
                    AtUsbHidGui.this.usbDevice.UnloadloadLibraryUsbHid();
                    System.exit(0);
                }
            });
            this.centerJFrame();
        }
        return this.jFrame;
    }

    private void centerJFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getJFrame().getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.getJFrame().setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BoxLayout(this.getJContentPane(), 1));
            this.jPanelButton = new AtUsbHidPanelButton(this);
            this.jContentPane.add((Component)this.jPanelButton.getJPanelButton(), null);
            this.jContentPane.add((Component)this.getJPanelText(), null);
            this.jPanelLed = new AtUsbHidPanelLed(this);
            this.jContentPane.add((Component)this.jPanelLed.getJPanelLed(), null);
            this.jContentPane.add((Component)this.getJPanelStatus(), null);
            this.setControlEnable(false);
            this.TaskReadText();
        }
        return this.jContentPane;
    }

    private JPanel getJPanelText() {
        if (this.jPanelText == null) {
            this.jPanelText = new JPanel();
            this.jPanelText.setLayout(new FlowLayout());
            this.jPanelText.add((Component)this.getJScrollPane(), null);
        }
        return this.jPanelText;
    }

    private JTextArea getJTextArea() {
        if (this.jTextArea == null) {
            this.jTextArea = new JTextArea();
        }
        return this.jTextArea;
    }

    private JPanel getJPanelStatus() {
        if (this.jPanelStatus == null) {
            this.jLabelBufferInfo = new JLabel("");
            this.jLabelStatus = new JLabel("Not Connected");
            this.jLabelStatus.setFont(new Font("Courier New", 1, 14));
            this.jLabelStatus.setForeground(Color.blue);
            this.jPanelStatus = new JPanel();
            this.jPanelStatus.setLayout(new BorderLayout());
            this.jPanelStatus.setBorder(BorderFactory.createTitledBorder(null, "Status", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.jPanelStatus.add((Component)this.jLabelStatus, "West");
            this.jPanelStatus.add((Component)this.jLabelBufferInfo, "East");
        }
        return this.jPanelStatus;
    }

    private void setControlEnable(boolean bl) {
        this.jPanelLed.setCommunicationEnable(bl);
        this.jPanelButton.setCommunicationEnable(bl);
    }

    public void setLed(int n, boolean bl) {
        byte[] byArray = new byte[this.usbDevice.getOutputReportLength()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        byArray[1] = (byte)(n + 48);
        if (bl) {
            byArray[0] = 49;
            this.jLabelStatus.setText("Led " + n + " is on");
        } else {
            byArray[0] = 48;
            this.jLabelStatus.setText("Led " + n + " is off");
        }
        if (!this.usbDevice.writeData(byArray)) {
            this.setDeviceConnected(false);
            this.jLabelStatus.setText("Connection to device lost during led setting");
        }
    }

    private void TaskReadText() {
        Timer timer = this.createTimer();
        timer.start();
    }

    private Timer createTimer() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                if (AtUsbHidGui.this.deviceConnected) {
                    byte[] byArray = AtUsbHidGui.this.usbDevice.readData();
                    if (byArray.length > 0) {
                        if (byArray[0] == 1) {
                            AtUsbHidGui.this.getJTextArea().append("Button as been pressed\n");
                        } else {
                            AtUsbHidGui.this.getJTextArea().append("Button as been released\n");
                        }
                        AtUsbHidGui.this.jLabelStatus.setText("New action on target");
                    }
                    byte[] byArray2 = new byte[AtUsbHidGui.this.usbDevice.getOutputReportLength()];
                    for (int i = 0; i < byArray2.length; ++i) {
                        byArray2[i] = 0;
                    }
                    if (byArray2.length >= 4) {
                        byArray2[0] = 85;
                        byArray2[1] = -86;
                        byArray2[2] = 85;
                        byArray2[3] = 85;
                    }
                    if (!AtUsbHidGui.this.usbDevice.setFeature(byArray2)) {
                        AtUsbHidGui.this.setDeviceConnected(false);
                        AtUsbHidGui.this.jLabelStatus.setText("Connection to device lost");
                    }
                } else if (AtUsbHidGui.this.autoConnect && (n = AtUsbHidGui.this.usbDevice.findHidDevice(AtUsbHidGui.this.jPanelButton.getVid(), AtUsbHidGui.this.jPanelButton.getPid())) == 1) {
                    AtUsbHidGui.this.setDeviceConnected(true);
                }
            }
        };
        return new Timer(100, actionListener);
    }

    public void setDeviceConnected(boolean bl) {
        this.jLabelBufferInfo.setText("");
        if (bl) {
            int n = this.usbDevice.findHidDevice(this.jPanelButton.getVid(), this.jPanelButton.getPid());
            switch (n) {
                case 1: {
                    this.jPanelButton.setCommunicationEnable(false);
                    this.setControlEnable(true);
                    this.setLed(1, false);
                    this.setLed(2, false);
                    this.setLed(3, false);
                    this.setLed(4, false);
                    if (!this.autoConnect) {
                        this.jLabelStatus.setText("Connected to the device");
                    } else {
                        this.jLabelStatus.setText("Auto-connected to the device");
                    }
                    this.jLabelBufferInfo.setText("Buffer Size, In:" + this.usbDevice.getInputReportLength() + "Byte, Out=" + this.usbDevice.getOutputReportLength() + "Byte, Feature" + this.usbDevice.getFeatureReportLength() + "Byte");
                    this.deviceConnected = true;
                    break;
                }
                case -1: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb Device Not Found", "AtUsbHidGui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb Device Not Found");
                    this.deviceConnected = false;
                    break;
                }
                case -2: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb no capabilities", "AtUsbHidGui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb no capabilities");
                    this.deviceConnected = false;
                    break;
                }
                default: {
                    if (!this.autoConnect) {
                        JOptionPane.showMessageDialog(this.getJFrame(), "Usb Unknown Error", "AtUsbHidGui.java error", 0);
                    }
                    this.jLabelStatus.setText("Usb Unknown Error");
                    this.deviceConnected = false;
                    break;
                }
            }
        } else {
            this.usbDevice.closeDevice();
            this.setControlEnable(false);
            this.jLabelStatus.setText("Disconneted from the device");
            this.deviceConnected = false;
        }
    }

    public void setAutoConnect(boolean bl) {
        this.autoConnect = bl;
    }

    public void startIsp() {
        byte[] byArray = new byte[this.usbDevice.getOutputReportLength()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        if (byArray.length >= 4) {
            byArray[0] = 85;
            byArray[1] = -86;
            byArray[2] = 85;
            byArray[3] = -86;
        }
        if (this.usbDevice.setFeature(byArray)) {
            this.setDeviceConnected(false);
            this.jLabelStatus.setText("Isp mode enable, you can run flip");
        } else {
            JOptionPane.showMessageDialog(this.getJFrame(), "Not able to start ISP mode", "AtUsbHidGui.java error", 0);
        }
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane(this.getJTextArea());
            this.jScrollPane.setPreferredSize(new Dimension(490, 120));
        }
        return this.jScrollPane;
    }

    public static void main(String[] stringArray) {
        AtUsbHidGui atUsbHidGui = new AtUsbHidGui();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            SwingUtilities.invokeAndWait(atUsbHidGui);
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

