//!
//! @file main.c,v
//!
//! Copyright (c) 2006 Atmel.
//!
//! Please read file license.txt for copyright notice.
//!
//! @brief Main for USB/OTG application.
//!
//! @version 1.1 at90usb128-otg-dual_role-toggle-1_0_0 $Id: main.c,v 1.1 2007/02/16 13:13:10 arobert Exp $
//!
//! @mainpage AT90USBxxxx USB OTG Library - HID Demonstration
//!
//! @section intro License
//! Use of this program is subject to Atmel's End User License Agreement.
//!
//! Please read file license.txt for copyright notice.
//!
//! @section install Description
//! This embedded application source code illustrates how to implement a simple application using the USB OTG library.
//! User must connect this board to another one that supports the OTG protocol, and that has the same firmware.
//! At the time of writing, only STK525 and USBKEY are OTG compatible (but not totally compliant), and can be connected together.
//! This application is customizable, please look at "conf_usb.h".
//!
//! @section sample About the sample application
//! This package is compatible with STK525 and USBKEY, user has just to set the board name in TARGET_BOARD ("config.h").
//! Boards must be configured in SELF POWERED mode (external power source).
//! The application uses both peripheral and host operating mode of the micro.
//! This application is reserved to OTG demonstration, and may not run correctly when attached to a standard PC (non-OTG).
//! Concept is simple : user has to press a button on the Peripheral board to toggle the LED state of the Host board.
//! But USB OTG features the following possibilities :
//!   PERIPHERAL MODE (default if MiniB inserted at start up)
//!     - press HWB button to send a SRP ; this work only in B-IDLE state (only if no Vbus detected)
//!     - once connected to Host, press CENTER button (joystick) to toggle the LED state
//!     - when connected as a peripheral, a LED should be continuously lighting to indicate this role
//!
//!   HOST MODE (default if MiniA inserted at start up)
//!     - press HWB button to toggle Vbus ON/OFF ; this works in any state of A-DEVICE (even A-PERIPHERAL)
//!     - if in A-HOST state, press CENTER button to initiate an HNP (and become A-PERIPHERAL)
//!
//!   MESSAGING FEATURE
//!     - refer to "otg_user_task.c" and "otg_user_task.h" to learn about LED signification
//!
//! @section arch Architecture
//! As illustrated in the figure below, the application entry point is located in the main.c file.
//! The main function first performs the initialization of a scheduler module and then runs it in an infinite loop.
//! The scheduler is a simple infinite loop calling all its tasks defined in the conf_scheduler.h file.
//! No real time schedule is performed, when a task ends, the scheduler calls the next task defined in
//! the configuration file (conf_scheduler.h).
//!
//! The application is based on two different tasks:
//! - The usb_task()  (usb_task.c associated source file), is the task performing the USB low level 
//!   enumeration process in peripheral mode or host mode, and calls either usb_device_task() or usb_host_task() 
//!   according to the ID pin (that determines the initial role configuration)
//! - The otg_user_task() handles both roles : connections and deconnections, high-level USB transferts
//!   and application level commands
//!
//! Refer to the corresponding Application Note (OTG Add-on to USB Library) for a complete information guide about OTG
//! and for more information about this package.
//!
//!

//_____  I N C L U D E S ___________________________________________________

#include "config.h"
#include "modules/scheduler/scheduler.h"
#include "lib_mcu/wdt/wdt_drv.h"
#include "lib_mcu/power/power_drv.h"

//_____ M A C R O S ________________________________________________________

//_____ D E F I N I T I O N S ______________________________________________

void main(void)
{
#ifndef  AVRGCC
   Wdt_off();
#else
   wdt_reset();
   Wdt_clear_flag();
   Wdt_change_enable();
   Wdt_stop();
#endif
   Clear_prescaler();
   scheduler();
}

#ifdef __cplusplus
extern "C" {
#endif
char __low_level_init()
{
  Clear_prescaler();
  return 1;
}
#ifdef __cplusplus
}
#endif
