/*This file has been prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief This file manages the USB Host mouse control application.
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2007, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//_____  I N C L U D E S ___________________________________________________

#include "config.h"
#include "conf_usb.h"
#include "host_mouse_task.h"
#include "modules/usb/host_chap9/usb_host_task.h"
#include "modules/usb/host_chap9/usb_host_enum.h"
#include "lib_mcu/usb/usb_drv.h"

//_____ M A C R O S ________________________________________________________

#ifndef LOG_STR_CODE
#define LOG_STR_CODE(str)
#else
U8 code log_mouse_connect[]="Mouse Connected";
#endif

//_____ D E F I N I T I O N S ______________________________________________


//_____ D E C L A R A T I O N S ____________________________________________

U8  mouse_connected=0;

U8  pipe_mouse_in;

//!@brief This function initializes the Host USB mouse application
//!
//!
//!@param none
//!
//!@return none
void host_mouse_task_init(void)
{
   Leds_init();
}

//! @brief This function manages the HOST mouse application
//!
//! @param none
//!
//! @return none
void host_mouse_task(void)
{
U8 i;
S8 new_x,new_y;

   //Test HID device connection
   if(Is_host_ready())
   {
      if(Is_new_device_connection_event())   //Device connection
      {
            mouse_connected=0;
            for(i=0;i<Get_nb_supported_interface();i++)
            {
               if(Get_class(i)==HID_CLASS && Get_protocol(i)==HID_PROTOCOL_MOUSE)
               {
                  mouse_connected=1;
                  host_hid_set_idle();
                  host_get_hid_repport_descriptor();                  
                  LOG_STR_CODE(log_mouse_connect);
                  PIPE_MOUSE_IN=host_get_hwd_pipe_nb(Get_ep_addr(i,0));
                  Host_select_pipe(PIPE_MOUSE_IN);
                  Host_continuous_in_mode();
                  Host_unfreeze_pipe();
                  break;
               }
            }
      }
      if(mouse_connected)
      {
         Host_select_pipe(PIPE_MOUSE_IN);
         if(Is_host_in_received())
         {
            if(Is_host_stall()==FALSE)
            {
               i=Host_read_byte();
               new_x=(S8)Host_read_byte();
               new_y=(S8)Host_read_byte();

               if(new_x==0)
               { Led0_off(); Led1_off();}
               else if(new_x>0)
               {Led0_on(); Led1_off();}
               else
               { Led0_off(); Led1_on();}

               if(new_y==0)
               { Led2_off(); Led3_off();}
               else if(new_y>0)
               { Led2_on(); Led3_off();}
               else
               { Led2_off(); Led3_on();}
            }
            Host_ack_in_received(); Host_send_in();
         }
         if(Is_host_nak_received())
         {
            Host_ack_nak_received();
            Led0_off(); Led1_off();
            Led2_off(); Led3_off();
         }

      }
   }
   //Device disconnection...
   if(Is_device_disconnection_event())
   {
      Leds_off();
      mouse_connected=0;
   }
}
