/*This file has been prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief USB Identifers.
//!
//!  This file contains the usb parameters that uniquely identify the
//!  application through descriptor tables.
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2007, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _USB_DESCRIPTORS_H_
#define _USB_DESCRIPTORS_H_

//_____ I N C L U D E S ____________________________________________________

#include "config.h"
#include "modules/usb/device_chap9/usb_standard_request.h"
#include "conf_usb.h"

//_____ M A C R O S ________________________________________________________

#define  Usb_get_dev_desc_pointer()        (&(usb_dev_desc.bLength))
#define  Usb_get_dev_desc_length()         (sizeof (usb_dev_desc))
#define  Usb_get_conf_desc_pointer()       (&(usb_conf_desc.cfg.bLength))
#define  Usb_get_conf_desc_length()        (sizeof (usb_conf_desc))



//_____ U S B    D E F I N E _______________________________________________

                  // USB Device descriptor
#define  USB_SPECIFICATION             0x0200
#define  DEVICE_CLASS                  0        // each configuration has its own class
#define  DEVICE_SUB_CLASS              0        // each configuration has its own sub-class
#define  DEVICE_PROTOCOL               0        // each configuration has its own protocol
#define  EP_CONTROL_LENGTH             64
#define  VENDOR_ID                     VID_ATMEL
#define  PRODUCT_ID                    PID_MegaAUDIO_IN
#define  RELEASE_NUMBER                0x1000
#define  MAN_INDEX                     0x01
#define  PROD_INDEX                    0x02   
#if (USB_DEVICE_SN_USE==ENABLE)
#define SN_INDEX                       0x03
#else
#define SN_INDEX                       0x00  // No serial number field
#endif
#define  NB_CONFIGURATION              1


               // USB mic configuration descriptor
#define  NB_INTERFACE                  2        // Audio Control + Audio Stream IN (Micro) interface
#define  CONF_NB                       1
#define  CONF_INDEX                    0
#define  CONF_ATTRIBUTES               USB_CONFIG_BUSPOWERED
#define  MAX_POWER                     50       // 100 mA
        
              // Standard Audio control (AC) interface descriptor
#define  AC_INTERFACE_NB               0                      // Interface's number
#define  AC_ALTERNATE                  0
#define  AC_NB_ENDPOINT                0                      // No endpoint for AC interface
#define  AC_INTERFACE_CLASS            AUDIO_CLASS            // Audio Class
#define  AC_INTERFACE_SUB_CLASS        AUDIO_SUB_CLASS_CONTROL// Audio_control sub class
#define  AC_INTERFACE_PROTOCOL         NO_PROTOCOL            // Unused
#define  AC_INTERFACE_INDEX            0
        
              // USB Endpoint 1 descriptor FS
#define  ENDPOINT_NB_1                 (EP_AUDIO_IN | USB_ENDPOINT_IN)
#define  EP_ATTRIBUTES_1               0x01     // BULK = 0x02, INTERUPT = 0x03
#define  EP_IN_LENGTH                  16
#define  EP_SIZE_1                     EP_IN_LENGTH
#define  EP_INTERVAL_1                 0x01     // One packet per frame

             // AC interface descriptor Audio specific
#define  NB_OF_STREAMING_INTERFACE     0x01
             // Input Terminal descriptor
#define  INPUT_TERMINAL_ID             0x01
#define  INPUT_TERMINAL_TYPE           AUDIO_TE_TYPE_INPUT_MICROPHONE   // Terminal is microphone
#define  INPUT_TERMINAL_ASSOCIATION    0x00                             // No association
#define  INPUT_TERMINAL_NB_CHANNELS    0x01                             // One channel for input terminal
#define  INPUT_TERMINAL_CHANNEL_CONF   AUDIO_CHANNEL_NO_POSITION        // Mono sets no position
#define  INPUT_TERMINAL_CH_NAME_ID     0x00                             // No channel name
             // Feature Unit Control descriptor
#define  FEATURE_UNIT_ID               0x02
#define  FEATURE_UNIT_SOURCE_ID        INPUT_TERMINAL_ID
#define  FEATURE_UNIT_CTRL_CH_MASTER   (AUDIO_FU_CONTROL_CS_MUTE|AUDIO_FU_CONTROL_CS_VOLUME) // Mute + Volume control on master channel
#define  FEATURE_UNIT_CTRL_CH_1        0x00                             // No control on channel 1
             // Output Terminal descriptor
#define  OUTPUT_TERMINAL_ID            0x03
#define  OUTPUT_TERMINAL_TYPE          AUDIO_TE_TYPE_USB_STREAMING      // USB Streaming
#define  OUTPUT_TERMINAL_ASSOCIATION   0x00                             // No association
#define  OUTPUT_TERMINAL_SOURCE_ID     FEATURE_UNIT_ID                  // From Feature Unit Terminal
             //Audio Streaming (AS) interface descriptor
#define  STD_AS_INTERFACE_NB           0x01                             // Index of Std AS Interface
             //Alternate O Audio Streaming (AS) interface descriptor
#define  ALT0_AS_INTERFACE_INDEX       0x00                             // Index of Std AS interface Alt0
#define  ALT0_AS_NB_ENDPOINT           0x00                             // Nb od endpoints for alt0 interface
#define  ALT0_AS_INTERFACE_CLASS       AUDIO_CLASS                      // Audio class
#define  ALT0_AS_INTERFACE_SUB_CLASS   AUDIO_SUB_CLASS_STREAMING        // Audio streamn sub class
#define  ALT0_AS_INTERFACE_PROTOCOL    NO_PROTOCOL                      // Unused
             //Alternate 1 Audio Streaming (AS) interface descriptor
#define  ALT1_AS_INTERFACE_INDEX       0x01                             // Index of Std AS interface Alt1
#define  ALT1_AS_NB_ENDPOINT           0x01                             // Nb od endpoints for alt1 interface
#define  ALT1_AS_INTERFACE_CLASS       AUDIO_CLASS                      // Audio class
#define  ALT1_AS_INTERFACE_SUB_CLASS   AUDIO_SUB_CLASS_STREAMING        // Audio streamn sub class
#define  ALT1_AS_INTERFACE_PROTOCOL    NO_PROTOCOL                      // Unused
             //AS general Interface descriptor
#define  AS_TERMINAL_LINK              0x03                             // Unit Id of the output terminal
#define  AS_DELAY                      0x01                             // Interface delay
#define  AS_FORMAT_TAG                 AUDIO_FORMAT_TI_PCM   // PCM Format
             // Format type
#define  FORMAT_TYPE                   AUDIO_FORMAT_TYPE_I     // Format TypeI
#define  FORMAT_NB_CHANNELS            0x01                             // One Channel
#define  FORMAT_FRAME_SIZE             0x02                             // Two bytes per audio sample
#define  FORMAT_BIT_RESOLUTION         0x10                             // 16 bits per sample
#define  FORMAT_SAMPLE_FREQ_NB         0x01                             // One frequency supported
#define  FORMAT_LSBYTE_SAMPLE_FREQ     0x1F40                           // 0x001F40=8kHz Sample frequency
#define  FORMAT_MSBYTE_SAMPLE_FREQ     0x00                             // MsByte of 0x001F40
        
             //Audio endpoint specific descriptor field
#define  AUDIO_EP_ATRIBUTES            0x00     // No sampling freq, no pitch, no pading
#define  AUDIO_EP_DELAY_UNIT           0x00     // Unused
#define  AUDIO_EP_LOCK_DELAY           0x0000   // Unused
        
#define  LANG_ID                       0x00
#define  DEVICE_STATUS                 USB_DEVICE_STATUS_BUS_POWERED


#define  USB_MN_LENGTH         5
#define  USB_MANUFACTURER_NAME \
{ Usb_unicode('A') \
, Usb_unicode('T') \
, Usb_unicode('M') \
, Usb_unicode('E') \
, Usb_unicode('L') \
}

#define  USB_PN_LENGTH         18
#define  USB_PRODUCT_NAME \
{ Usb_unicode('A') \
 ,Usb_unicode('V') \
 ,Usb_unicode('R') \
 ,Usb_unicode(' ') \
 ,Usb_unicode('U') \
 ,Usb_unicode('S') \
 ,Usb_unicode('B') \
 ,Usb_unicode(' ') \
 ,Usb_unicode('A') \
 ,Usb_unicode('U') \
 ,Usb_unicode('D') \
 ,Usb_unicode('I') \
 ,Usb_unicode('O') \
 ,Usb_unicode(' ') \
 ,Usb_unicode('D') \
 ,Usb_unicode('E') \
 ,Usb_unicode('M') \
 ,Usb_unicode('O') \
}

#define  USB_SN_LENGTH         0x05
#define  USB_SERIAL_NUMBER \
{ Usb_unicode('0') \
 ,Usb_unicode('0') \
 ,Usb_unicode('0') \
 ,Usb_unicode('0') \
 ,Usb_unicode('0') \
}
                           //Audio Channel Name
#define  AUDIO_CHANNEL_NAME \
{ Usb_unicode('A') \
, Usb_unicode('T') \
, Usb_unicode('M') \
, Usb_unicode('E') \
, Usb_unicode('L') \
}

#define  LANGUAGE_ID           0x0409


                  //! Usb Request
typedef struct
{
   U8    bmRequestType;       //!< Characteristics of the request
   U8    bRequest;            //!< Specific request
   U16   wValue;              //!< field that varies according to request
   U16   wIndex;              //!< field that varies according to request
   U16   wLength;             //!< Number of bytes to transfer if Data
}  S_UsbRequest;


                //! Usb Device Descriptor
typedef struct {
   U8    bLength;             //!< Size of this descriptor in bytes
   U8    bDescriptorType;     //!< DEVICE descriptor type
   U16   bscUSB;              //!< Binay Coded Decimal Spec. release
   U8    bDeviceClass;        //!< Class code assigned by the USB
   U8    bDeviceSubClass;     //!< Sub-class code assigned by the USB
   U8    bDeviceProtocol;     //!< Protocol code assigned by the USB
   U8    bMaxPacketSize0;     //!< Max packet size for EP0
   U16   idVendor;            //!< Vendor ID. ATMEL = 0x03EB
   U16   idProduct;           //!< Product ID assigned by the manufacturer
   U16   bcdDevice;           //!< Device release number
   U8    iManufacturer;       //!< Index of manu. string descriptor
   U8    iProduct;            //!< Index of prod. string descriptor
   U8    iSerialNumber;       //!< Index of S.N.  string descriptor
   U8    bNumConfigurations;  //!< Number of possible configurations
}  S_usb_device_descriptor;


          //! Usb Configuration Descriptor
typedef struct {
   U8    bLength;             //!< size of this descriptor in bytes
   U8    bDescriptorType;     //!< CONFIGURATION descriptor type
   U16   wTotalLength;        //!< total length of data returned
   U8    bNumInterfaces;      //!< number of interfaces for this conf.
   U8    bConfigurationValue; //!< value for SetConfiguration resquest
   U8    iConfiguration;      //!< index of string descriptor
   U8    bmAttibutes;         //!< Configuration characteristics
   U8    MaxPower;            //!< maximum power consumption
}  S_usb_configuration_descriptor;


              //! Usb Interface Descriptor
typedef struct {
   U8    bLength;             //!< size of this descriptor in bytes
   U8    bDescriptorType;     //!< INTERFACE descriptor type
   U8    bInterfaceNumber;    //!< Number of interface
   U8    bAlternateSetting;   //!< value to select alternate setting
   U8    bNumEndpoints;       //!< Number of EP except EP 0
   U8    bInterfaceClass;     //!< Class code assigned by the USB
   U8    bInterfaceSubClass;  //!< Sub-class code assigned by the USB
   U8    bInterfaceProtocol;  //!< Protocol code assigned by the USB
   U8    iInterface;          //!< Index of string descriptor
}  S_usb_interface_descriptor;


            //! A U D I O Specific
            //! Class-Specific AC Interface Descriptor
typedef struct {
   U8    bLength;             //!< Size of this descriptor in bytes
   U8    bDescriptorType;     //!< CS interface
   U8    bDescritorSubtype;   //!< HEADER Subtype 
   U16   bcdADC;              //!< Revision of class spec 
   U16   wTotalLength;        //!< Total size of class specific descriptor 
   U8    bInCollection;       //!< Number of streaming interface 
   U8    baInterface1;        //!< Interface number of the first AudioStreaming or MIDIStreaming interface in the Collection.
} S_usb_ac_interface_descriptor;

            //! Class-Specific Input Terminal Descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;
   U8    bTerminalID;
   U16   wTerminalType;
   U8    bAssocTerminal;
   U8    bNrChannels;
   U16   wChannelConfig;
   U8    iChannelNames;
   U8    iTerminal;
} S_usb_in_ter_descriptor;

            //! Class-Specific Feature Unit Descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;
   U8    bUnitID;
   U8    bSourceID;
   U8    bControSize;
   U8    bmaControlMaster;
   U8    bmaControlCh1;
} S_usb_feature_unit_descriptor;

            //! Class-Specific Output Terminal Descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;
   U8    bTerminalID;
   U16   wTerminalType;
   U8    bAssocTerminal;
   U8    bSourceID;
   U8    iTerminal;
} S_usb_out_ter_descriptor;

            //! Class-Specific AS Interface Descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;
   U8    bTerminalLink;
   U8    bDelay;
   U16   wFormatTag;
} S_usb_as_interface_descriptor;

            //! Audio Format Type descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;
   U8    bFormatType;
   U8    bNrChannels;
   U8    bSubFrameSize;
   U8    bBitResolution;
   U8    bSampleFreqType;
   U16   wLsbyteiSamFreq;
   U8    bMsbyteiSamFreq;
} S_usb_format_type;

            //! Endpoint AUDIO Specific descriptor
typedef struct{
   U8    bLenght;
   U8    bDescriptorType;
   U8    bDescriptorSubType;   
   U8    bmAttributes;
   U8    bLockDelayUnits;
   U16   wLockDelay;
}S_usb_endpoint_audio_specific;

               //! Usb Audio Endpoint Descriptor
typedef struct {
   U8    bLength;             //!< Size of this descriptor in bytes
   U8    bDescriptorType;     //!< ENDPOINT descriptor type
   U8    bEndpointAddress;    //!< Address of the endpoint
   U8    bmAttributes;        //!< Endpoint's attributes
   U16   wMaxPacketSize;      //!< Maximum packet size for this EP
   U8    bInterval;           //!< Interval for polling EP in ms
   U8    bRefresh;
   U8    bSynAddress;
} S_usb_endpoint_audio_descriptor;

               //! Usb Endpoint Descriptor
typedef struct {
   U8    bLength;             //!< Size of this descriptor in bytes
   U8    bDescriptorType;     //!< ENDPOINT descriptor type
   U8    bEndpointAddress;    //!< Address of the endpoint
   U8    bmAttributes;        //!< Endpoint's attributes
   U16   wMaxPacketSize;      //!< Maximum packet size for this EP
   U8    bInterval;           //!< Interval for polling EP in ms
} S_usb_endpoint_descriptor;


               //! Usb Language Descriptor
typedef struct {
   U8    bLength;             //!< size of this descriptor in bytes
   U8    bDescriptorType;     //!< STRING descriptor type
   U16   wlangid;             //!< language id
}  S_usb_language_id;


//_____ U S B   M A N U F A C T U R E R   D E S C R I P T O R _______________


//struct usb_st_manufacturer
typedef struct {
   U8    bLength;             //!< size of this descriptor in bytes
   U8    bDescriptorType;     //!< STRING descriptor type
   U16   wstring[USB_MN_LENGTH]; //!< unicode characters
} S_usb_manufacturer_string_descriptor;


//_____ U S B   P R O D U C T   D E S C R I P T O R _________________________


//struct usb_st_product
typedef struct {
   U8    bLength;             //!< size of this descriptor in bytes
   U8    bDescriptorType;     //!< STRING descriptor type
   U16   wstring[USB_PN_LENGTH]; //!< unicode characters
} S_usb_product_string_descriptor;


//_____ U S B   S E R I A L   N U M B E R   D E S C R I P T O R _____________


#if (USB_DEVICE_SN_USE==ENABLE)
//struct usb_st_serial_number
typedef struct {
   U8  bLength;               // size of this descriptor in bytes
   U8  bDescriptorType;       // STRING descriptor type
#if (USE_DEVICE_SN_UNIQUE==ENABLE)

#else   
   U16 wstring[USB_SN_LENGTH];// unicode characters
#endif
} S_usb_serial_number;
#endif


//_____ U S B   A U D I O   D E S C R I P T O R _____________________________

typedef struct
{
   S_usb_configuration_descriptor   cfg;
   S_usb_interface_descriptor       ifc;
   S_usb_ac_interface_descriptor    audioac;
   S_usb_in_ter_descriptor          mic_in_ter;
   S_usb_feature_unit_descriptor    mic_fea_unit;
   S_usb_out_ter_descriptor         mic_out_ter;
   S_usb_interface_descriptor       mic_as_alt0;   
   S_usb_interface_descriptor       mic_as_alt1;   
   S_usb_as_interface_descriptor    mic_g_as;
   S_usb_format_type                mic_format_type;
   S_usb_endpoint_audio_descriptor  ep1;
   S_usb_endpoint_audio_specific    ep1_s;
} S_usb_user_configuration_descriptor;

#endif

