# Copyright (C) 2008, Atmel Corporation All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# 3. The name of ATMEL may not be used to endorse or promote products derived
# from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
# WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
# SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
# INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
# THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

PHONY		:= all _all
all: _all

# Start from a clean slate
subdir-y	:=
obj-y		:=
ldscript-y	:=

cppflags-y	:=
asflags-y	:=
cflags-y	:=
ldflags-y	:=
progflags-y	:=
mkfiles		:=

include $(src)/make/common.mk

appsrc		:= $(src)/apps/$(app)
appimg		:= $(app).elf

# Look for source files relative to the top-level source directory
VPATH		:= $(src)

config_mk	:= $(appsrc)/config-$(BOARD).mk
config_h	:= include/autoconf.h

quiet_cmd_genconfig = CONF    $@
      cmd_genconfig = $(src)/make/genconfig.sh < $< > $@ || rm -f $@

$(config_h): $(config_mk)
	$(call cmd,mkdir)
	$(call cmd,genconfig)

include $(config_mk)
mkfiles		+= $(config_mk)

CC		:= $(CROSS_COMPILE)gcc
CPP		:= $(CC) -E
AS		:= $(CROSS_COMPILE)as
LD		:= $(CROSS_COMPILE)ld
OBJDUMP		:= $(CROSS_COMPILE)objdump
OBJCOPY		:= $(CROSS_COMPILE)objcopy
SIZE		:= $(CROSS_COMPILE)size
PROG		:= avr32program

CHECK		:= sparse

# First, config.h and other generated header files
cppflags-y	+= -include $(config_h) -Iinclude

include $(appsrc)/$(app).mk
mkfiles		+= $(appsrc)/$(app).mk
include $(src)/make/app-subdirs.mk
subdir-mkfiles	:= $(patsubst %,$(src)/%/subdir.mk,$(subdir-y))
include $(subdir-mkfiles)

mkfiles		+= $(src)/make/app-build.mk

_all: $(appimg) $(bootimg-y)

# Always enable warnings. And be very careful about implicit
# declarations
cflags-y	+= -Wall -Wstrict-prototypes -Wmissing-prototypes
cflags-y	+= -Werror-implicit-function-declaration

# Then, chip- and arch-specific header files
include $(src)/board/$(CONFIG_BOARD)/board.mk

all-targets	:= $(obj-y) $(ldscript-y)
clean-files	+= $(appimg) $(app).s $(obj-y) $(obj-y:.o=.s)
clean-files	+= $(config_h) $(ldscript-y)

# Finally, generic and gcc-supplied header files
cppflags-y	+= -I$(src)/include

gcc-dir		 = "$(dir $(shell $(CC) -print-libgcc-file-name))"
checkflags-y	:= -Wall -I$(gcc-dir)/include $(cppflags-y)

c_flags		= -Wp,-MD,$(depfile) -MQ $@ -MP $(cppflags-y) $(cflags-y)
a_flags		= -Wp,-MD,$(depfile) -MQ $@ -MP $(cppflags-y) $(asflags-y) -D__ASSEMBLY__
l_flags		= -T $(ldscript-y) $(ldflags-y) -Map $@.map --cref

quiet_cmd_cc_o_c	= CC      $@
      cmd_cc_o_c	= $(CC) $(c_flags) -c -o $@ $<
quiet_cmd_cc_s_c	= CC      $@
      cmd_cc_s_c	= $(CC) $(c_flags) -fverbose-asm -S -o $@ $<
quiet_cmd_as_o_S	= AS      $@
      cmd_as_o_S	= $(CC) $(a_flags) -c -o $@ $<
quiet_cmd_cpp_i_c	= CPP     $@
      cmd_cpp_i_c	= $(CPP) $(c_flags) -o $@ $<
quiet_cmd_cpp_lds_S	= LDS     $@
      cmd_cpp_lds_S	= $(CPP) -xassembler-with-cpp $(a_flags) -P -o $@ $<
quiet_cmd_link		= LD      $@
      cmd_link		= $(LD) $(l_flags) -o $@ $(obj-y) $(ldlibs-y)
quiet_cmd_check		= CHECK   $<
      cmd_check		= $(CHECK) $(checkflags-y) $<

%.o: %.c $(config_h) $(mkfiles)
	$(call cmd,mkdir)
	$(call cmd,cc_o_c)
ifeq ($(CONFIG_SPARSE),y)
	$(call cmd,check)
endif

%.i: %.c $(config_h) $(mkfiles)
	$(call cmd,mkdir)
	$(call cmd,cpp_i_c)

%.s: %.c $(config_h) $(mkfiles)
	$(call cmd,mkdir)
	$(call cmd,cc_s_c)

%.o: %.S $(config_h) $(mkfiles)
	$(call cmd,mkdir)
	$(call cmd,as_o_S)

%.lds: %.lds.S $(config_h) $(mkfiles)
	$(call cmd,mkdir)
	$(call cmd,cpp_lds_S)

$(appimg): $(obj-y) $(ldscript-y)
	$(call cmd,mkdir)
	$(call cmd,link)
	$(Q)$(SIZE) $@

# Disassembling the final binary
$(app).s: $(appimg)
	$(OBJDUMP) -d $< > $@ || rm -f $@

include $(src)/make/commands.mk

dep-files := $(wildcard $(foreach f,$(all-targets),$(dir $(f)).$(notdir $(f)).d))
clean-files += $(dep-files)

PHONY		+= clean
clean:
	$(call cmd,rmfiles)

progflags-$(CONFIG_PROG_VERIFY)	+= -v

PHONY		+= program reset run
program: $(appimg)
	$(PROG) program $(progflags-y) -e $<

reset:
	$(PROG) reset

run:
	$(PROG) run

include $(dep-files)

.PHONY: $(PHONY)
