/**
 * \file
 *
 * \brief dlmalloc() customization definitions
 *
 * This file includes a number of defines used to customize the
 * dlmalloc() implementation.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 AP7 devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef DLMALLOC_CONFIG_H
#define DLMALLOC_CONFIG_H

#include <bitops.h>
#include <physmem.h>
#include <types.h>

#define MALLOC_ALIGN_ORDER	5

static void *dlmalloc_morecore(long increment)
{
	phys_addr_t phys;

	if (increment < 0)
		increment = 0;

	phys = physmem_alloc_low(&cpu_sram_pool, increment, MALLOC_ALIGN_ORDER);
	if (phys == PHYSMEM_ALLOC_ERR)
		return (void *)(-1);

	return physmem_map(phys, increment, PHYS_MAP_WRBACK);
}

#define fprintf(file, ...)	do { } while (0)

#define MALLOC_ALIGNMENT	((size_t)1 << 5)
#define ABORT			assert(0)
#define ABORT_ON_ASSERT_FAILURE	(0)
#define MALLOC_FAILURE_ACTION	do { } while (0)
#define MORECORE(incr)		dlmalloc_morecore(incr)
#define MORECORE_CANNOT_TRIM	(1)
#define HAVE_MMAP		(0)
#define HAVE_MREMAP		(0)
#define USE_BUILTIN_FFS		(1)
#define malloc_getpagesize	(1024)

#define LACKS_UNISTD_H		1
#define LACKS_FCNTL_H		1
#define LACKS_SYS_PARAM_H	1
#define LACKS_SYS_MMAN_H	1
#define LACKS_STDLIB_H		1
#define LACKS_STDIO_H		1
#define LACKS_STRINGS_H		1
#define LACKS_SYS_TYPES_H	1
#define LACKS_ERRNO_H		1

#endif /* DLMALLOC_CONFIG_H */
