/**
 * \file
 *
 * \brief USB Mass Storage Class function driver.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices with a USB device controller
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef USB_MSC_FUNC_H_INCLUDED
#define USB_MSC_FUNC_H_INCLUDED

/**
 * \brief Maximum number of characters in the device serial number.
 *
 * Note that there's usually no point in having more than 12 characters.
 */
#define MSC_MAX_SERIAL_LEN	20

struct block_device;

extern struct usb_func_iface *usb_msc_func_init(struct block_device *bdev);

extern void usb_msc_set_busy(struct usb_func_iface *iface, uint16_t asc,
		void (*queue_empty)(void *data), void *data);
extern void usb_msc_set_ready(struct usb_func_iface *iface);

static inline bool msc_serial_number_is_valid(const char *str, size_t max_len)
{
	size_t	len;
	char	c;

	for (len = 0; len < max_len; len++) {
		c = str[len];
		if (c == 0)
			break;

		if ((c < '0' || c > '9') && (c < 'A' || c > 'F'))
			return false;
	}

	if (len < 12 || len == max_len || len > MSC_MAX_SERIAL_LEN)
		return false;

	return true;
}

#endif /* USB_MSC_FUNC_H_INCLUDED */
