/**
 * \file
 *
 * \brief GPIO irq handler
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices with a GPIO module
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef GPIO_GPIO_IRQ_HANDLER_H_INCLUDED
#define GPIO_GPIO_IRQ_HANDLER_H_INCLUDED

#include <slist.h>
#include <chip/portmux.h>

/**
 * \brief GPIO irq handler
 */
struct gpio_irq_handler {
	/** slist node */
	struct slist_node	node;
	/** GPIO pin */
	gpio_pin_t		pin;
	/** Handler function pointer */
	void			(*handler)(void *data);
	/** Handler private data */
	void			*data;
};

/**
 * \brief Init GPIO irq handler
 *
 * \param irqh Pointer to gpio_irq_handler
 * \param handler Sub handler callback
 * \param data sub handler private data
 */
static inline void gpio_init_irq_handler(struct gpio_irq_handler *irqh,
		gpio_pin_t pin, void (*handler)(void *data), void *data)
{
	irqh->pin = pin;
	irqh->handler = handler;
	irqh->data = data;
}

/**
 * \brief Register GPIO irq handler
 *
 * \param irqh handler to register
 */
extern void gpio_register_irq_handler(struct gpio_irq_handler *irqh);

/**
 * \private
 * \brief GPIO group interrupt handler
 */
extern void gpio_priv_irq_group_interrupt(void *data);

#endif /* GPIO_GPIO_IRQ_HANDLER_H_INCLUDED */

