/**
 * \file
 *
 * \brief Compiler abstraction layer: IAR specifics
 *
 * - Compiler:           IAR EWAVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef COMPILER_IAR_H_INCLUDED
#define COMPILER_IAR_H_INCLUDED

#include <intrinsics.h>

#define __noreturn	__noreturn
#define __used		__root
#define __always_inline	_Pragma("inline=forced")

#define barrier()	asm("")

/* These are undocumented, but appear to work */
#define min(a, b)	__min(a, b)
#define max(a, b)	__max(a, b)

/* Atomic operations. These are available as builtins on gcc */
static inline unsigned int __sync_or_and_fetch(unsigned int *addr,
		unsigned int mask)
{
	unsigned int word;

	do {
		__set_status_flag(5);
		barrier();
		word = *addr;
		word |= mask;
	} while (!__store_conditional(addr, word));

	barrier();

	return word;
}

static inline unsigned int __sync_and_and_fetch(unsigned int *addr,
		unsigned int mask)
{
	unsigned int word;

	do {
		__set_status_flag(5);
		barrier();
		word = *addr;
		word &= mask;
	} while (!__store_conditional(addr, word));

	barrier();

	return word;
}

static inline unsigned int __sync_xor_and_fetch(unsigned int *addr,
		unsigned int mask)
{
	unsigned int word;

	do {
		__set_status_flag(5);
		barrier();
		word = *addr;
		word ^= mask;
	} while (!__store_conditional(addr, word));

	barrier();

	return word;
}

static inline unsigned int __sync_fetch_and_or(unsigned int *addr,
		unsigned int mask)
{
	unsigned int word;
	unsigned int old;

	do {
		__set_status_flag(5);
		barrier();
		word = *addr;
		old = word;
		word |= mask;
	} while (!__store_conditional(addr, word));

	barrier();

	return old;
}

static inline unsigned int __sync_fetch_and_and(unsigned int *addr,
		unsigned int mask)
{
	unsigned int word;
	unsigned int old;

	do {
		__set_status_flag(5);
		barrier();
		word = *addr;
		old = word;
		word &= mask;
	} while (!__store_conditional(addr, word));

	barrier();

	return old;
}

#endif /* COMPILER_IAR_H_INCLUDED */
