/**
 * \file
 *
 * \brief AES block device interface
 *
 * This is the interface of the AES block device.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#ifndef AESBLK_H_INCLUDED
#define AESBLK_H_INCLUDED

#include <workqueue.h>
#include <block/device.h>
#include <aes.h>

struct workqueue	main_workqueue;

#define AES_BLK_STATE_LIST_ENCRYPTION_DONE	(1 << 0)
#define AES_BLK_STATE_REQ_ENCRYPTION_DONE	(1 << 1)
#define AES_BLK_STATE_LIST_DECRYPTION_DONE	(1 << 2)
#define AES_BLK_STATE_REQ_DECRYPTION_DONE	(1 << 3)
#define AES_BLK_STATE_WRITE_REQ_DONE		(1 << 4)
#define AES_BLK_STATE_WRITE_LIST_DONE		(1 << 5)
#define AES_BLK_STATE_WRITE_REQ_DONE_PENDING	(1 << 30)
#define AES_BLK_STATE_DECRYPTION_DONE_PENDING	(1 << 31)

struct aes_block_device {
	struct aes_module module;
	struct udc *udc;
	struct block_device bdev;
	struct block_device *card_bdev;
};

struct aes_block_request {
	struct aes_block_device *abdev;
	/** \brief Block request interface provided to USB MSC */
	struct block_request breq;
	/** \brief Block request used against the underlying device */
	struct block_request *card_breq;
	struct workqueue_item worker_item;
	struct slist buf_list;
	unsigned int state;
	int buf_counter;
};

void aesblk_update(struct aes_block_device *aes_bdev);
void aesblk_prepare_req(struct block_device *bdev,
		struct block_request *breq,
		uint32_t lba, uint32_t nr_blocks,
		enum block_operation operation);
struct block_request *aesblk_alloc_req(struct block_device *bdev);
void aesblk_free_req(struct block_device *bdev,
		struct block_request *breq);
void aesblk_init(struct aes_block_device *aes_bdev,
		struct block_device *card_bdev);

#endif /* AESBLK_H_INCLUDED */
