/**
 * \file
 *
 * \brief SD/MMC request utility functions
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#include <bitops.h>
#include <byteorder.h>
#include <debug.h>
#include <stdbool.h>
#include <string.h>
#include <util.h>
#include <sdmmc/sdmmc.h>
#include "protocol.h"

void sdmmc_req_prep_transfer(struct sdmmc_slot *slot, struct sdmmc_request *req,
		uint32_t lba, uint32_t nr_blocks, bool write)
{
	uint8_t	opcode;

	req->block_size = slot->card.block_size;
	req->blocks = nr_blocks;
	req->flags = 0;
	if (write)
		set_bit(SDMMC_REQ_WRITE, &req->flags);

	if (nr_blocks > 1) {
		set_bit(SDMMC_REQ_STOP, &req->flags);
		if (write)
			opcode = SDMMC_WRITE_MULTIPLE_BLOCK;
		else
			opcode = SDMMC_READ_MULTIPLE_BLOCK;
	} else {
		if (write)
			opcode = SDMMC_WRITE_BLOCK;
		else
			opcode = SDMMC_READ_SINGLE_BLOCK;
	}

	lba = sdmmc_card_block2addr(&slot->card, lba);

	sdmmc_req_prep_cmd(req, opcode, lba, SDMMC_RSP_R1);
}
