/**
 * \file
 *
 * \brief PDCA Hardware Register Definitions
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef PDCA_REGS_H_INCLUDED
#define PDCA_REGS_H_INCLUDED

#define PDCA_CHAN_MAR		0x00
#define PDCA_CHAN_PSR		0x04
# define PDCA_PSR_PID(x)		((x) <<  0)
#define PDCA_CHAN_TCR		0x08
#define PDCA_CHAN_MARR		0x0c
#define PDCA_CHAN_TCRR		0x10
#define PDCA_CHAN_CR		0x14
# define PDCA_CR_TEN			(  1 <<  0)
# define PDCA_CR_TDIS			(  1 <<  1)
# define PDCA_CR_ECLR			(  1 <<  8)
#define PDCA_CHAN_MR		0x18
# define PDCA_MR_SIZE(x)		((x) <<  0)
#  define PDCA_SIZE_BYTE			0
#  define PDCA_SIZE_HWORD			1
#  define PDCA_SIZE_WORD			2
#define PDCA_CHAN_SR		0x1c
# define PDCA_SR_TEN			(  1 <<  0)
#define PDCA_CHAN_IER		0x20
#define PDCA_CHAN_IDR		0x24
#define PDCA_CHAN_IMR		0x28
#define PDCA_CHAN_ISR		0x2c
# define PDCA_INT_RCZ			(  1 <<  0)
# define PDCA_INT_TRC			(  1 <<  1)
# define PDCA_INT_TERR			(  1 <<  2)

#define PDCA_CHAN_REGS_SIZE	0x40

#define pdca_chan_read_reg(chan, reg)				\
	mmio_read32(chan->regs + PDCA_CHAN_##reg)
#define pdca_chan_write_reg(chan, reg, value)			\
	mmio_write32(chan->regs + PDCA_CHAN_##reg, value)

#endif /* PDCA_REGS_H_INCLUDED */
