/**
 * \file
 *
 * \brief Timer documentation
 *
 * This file contains an overview of the timer implementation. It does not
 * contain any code.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * \page timer_overview Timer Overview
 *
 * The timer is intended to provide simple delay and timing functionality.
 * Tasks are submitted to the timer together with the desired delay, after
 * which the task will be executed.
 *
 * \section timer_setup Setting up the Timer
 *
 * The timer is set up by the timer_init() function. This function will map a
 * hardware Timer module to the timer struct, and initialize the Timer to give
 * the desired resolution.
 *
 * \section timer_task_setup Adding tasks to the Timer
 *
 * Before use, the timer tasks are set up with the timer_init_task() function.
 * When the task has been set up, it can be added to the timer by either the
 * timer_add_task_ticks() function or the convenience wrapper
 * timer_add_task_us(). When the given delay has passed, the tasks callback
 * function will be called by the timer.
 *
 * \subsection timer_task_reuse Re-using a Task
 *
 * When the task has started execution (ie. its callback has been called), the
 * task struct can be re-used and added to the timer again. If the callback or
 * data should be changed, the task should be reinitialized by calling
 * timer_init_task() again. If only the delay is to change, the task can be
 * re-used as soon as its callback is called.
 */
