/**
 * \file
 *
 * \brief Build System Overview
 *
 * This file provides an overview of the build system. It does not
 * contain any code by itself.
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * \page Build-system Build System Overview
 *
 * The AVR software framework includes its own build system consisting
 * of a large number of Makefiles. This page intends to explain how
 * those Makefiles work together, and how they are used to build
 * applications.
 *
 * \section Building-applications Building an Application
 *
 * To build an application, simply enter the appropriate directory
 * under apps/ and type "make". This results in a new directory being
 * created under build/ where the results of the build process will be
 * stored, if it didn't exist already. After performing this step
 * once, subsequent builds can be done either by running "make" from
 * the application directory as before, or by running "make" from the
 * build directory.
 *
 * Each application has a default board for which the application will
 * be built unless otherwise specified. To build the application for a
 * different board, simply set the \c BOARD environment variable to
 * the name of the desired board when running "make", for example like
 * this:
 *
 * \verbatim make BOARD=atstk1005 \endverbatim
 *
 * By default, the build process is quite silent, only listing which
 * files are being built, not the full command lines used to build
 * them. To see the full commands, enable <i>verbose mode</i> by
 * setting the environment variable \c V to 1:
 *
 * \verbatim make V=1 \endverbatim
 *
 * \subsection Build-targets Build Targets
 *
 * If no target is specified on the "make" command line, the
 * application will simply be built as an ELF file. Other
 * possibilities are:
 * - \a clean - Delete the ELF file and all intermediate build
 *   products.
 * - \a program - Build the ELF file and program it into flash on the
 *   target.
 * - \a reset - Reset the target.
 * - \a run - Start executing code on the target.
 *
 * Several targets may be specified on the command line -- they will
 * be executed in the order specified. For example, the following
 * command will build the ELF file, program it into the target, and
 * start running from the reset vector:
 *
 * \verbatim make program reset run \endverbatim
 *
 * \section Subdir-makefiles Subdirectory Makefiles
 *
 * Each subdirectory contains a Makefile fragment specifying which
 * source files that are to be built into objects, and sometimes which
 * additional subdirectories to include in the build. This Makefile
 * fragment is usually called \b subdir.mk, but there are some
 * exceptions to this rule:
 * - Application subdirectory Makefiles are named <b>\$(app).mk</b>
 * - Chip-, cpu-, arch- and board-specific Makefiles are named
 *   <b>chip.mk</b>, <b>cpu.mk</b>, <b>arch.mk</b> and <b>board.mk</b>
 *   respectively.
 *
 * The subdirectory Makefiles are usually very small, only appending
 * to a single variable, \a obj-y, which specifies which objects to
 * build, but there are other variables that may be altered by
 * subdirectory Makefiles as well:
 * - \b cppflags-y - C preprocessor flags for all files
 * - \b cflags-y - C compiler flags for all files
 * - \b ldflags-y - Linker flags for the final link
 * - \b ldlibs-y - Libraries to include in the final link
 *
 * The reason why all these variables have the suffix -y is to make it
 * easier to support conditional compilation and conditional flags.
 * For example, if a certain object is to be built only when
 * CONFIG_USB is set to 'y', this can be achieved as follows:
 * \verbatim obj-$(CONFIG_USB)	+= drivers/usb/usb.o \endverbatim
 *
 * \section Application-makefiles Makefiles Provided by the Application
 *
 * \subsection Top-level-makefile The Top-level Application Makefile
 *
 * Each application found under the apps/ subdirectory contains its
 * own top-level Makefile which can be used to build that particular
 * application. It is usually very simple, delegating the vast
 * majority of the work to the build system core.
 *
 * \par Example: apps/hello/Makefile
 * \include apps/hello/Makefile
 *
 * The following variables must be defined by the top-level
 * Application Makefile:
 * - \a src - The relative path to the top-level source directory
 * - \a app - The name of the application. <b>\$(src)/apps/\$(app)</b>
 *   must resolve to the directory in which the Makefile resides.
 * - \a DEFAULT_BOARD - The name of the board to build for when the user
 *   doesn't specify any particular board.
 *
 * After defining these variables, the Makefile should simply include
 * <b>\$(src)/make/app.mk</b> to take care of the rest.
 *
 * \subsection Config-mk Configuration Makefiles
 *
 * Each application must provide one or more configuration files for
 * the build system. These are named <b>config-<i>board</i>.mk</b>,
 * for each supported board. All applications must provide a
 * configuration file for the default board; configuration files for
 * any other boards is optional.
 *
 * The configuration files may contain all kinds of Makefile variable
 * definitions, but its primary purpose is to specify configuration
 * variables. These variables are available both to the build system
 * and to the source files, so they need to follow a few special
 * rules:
 * - The variable name must begin with \c CONFIG_
 * - The variable name must be followed by a '=' character and a value
 *   with no spaces in between.
 * - String values must be surrounded by double quotes.
 * - Boolean values must be either 'y' or 'n'.
 * - Integer values are expressed using any valid C syntax.
 *
 * During the build process, this file is used as a source for
 * generating the \b autoconf.h file, which is included implicitly in
 * all source files. The variables are converted as follows:
 * - Boolean variables set to 'y' become preprocessor symbols defined
 *   as 1.
 * - Boolean variables set to 'n' are not defined (so \#ifdef can be
 *   used to test the value of boolean configuration variables.)
 * - String and integer variables become preprocessor symbols defined
 *   as their respective literal values (including the quotes for
 *   string variables.)
 *
 * \subsection App-subdir-makefile Application Subdirectory Makefile
 *
 * The application must include a file named <b>\$(app).mk</b>
 * specifying any application-specific object files and flags. This
 * file follows the syntax described in the section \ref
 * Subdir-makefiles.
 */
