/**
 * \file
 *
 * \brief ATEVK1104 clock configuration
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  ATEVK1104
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef BOARD_CLK_H
#define BOARD_CLK_H

/** \brief OSC32 rate in Hz */
#define BOARD_OSC32_HZ		32768
/** \brief OSC32 startup time in microseconds */
#define BOARD_OSC32_STARTUP_US	71000
/** \brief OSC32 is a crystal, not an external clock */
#define BOARD_OSC32_XTAL	1

/** \brief OSC0 rate in Hz */
#define BOARD_OSC0_HZ		12000000
/** \brief OSC0 startup time in microseconds */
#define BOARD_OSC0_STARTUP_US	18000
/** \brief OSC0 is a crystal, not an external clock */
#define BOARD_OSC0_XTAL		1

/** \brief OSC1 rate in Hz */
#define BOARD_OSC1_HZ		11289600
/** \brief OSC1 startup time in microseconds */
#define BOARD_OSC1_STARTUP_US	18000
/** \brief OSC1 is a crystal, not an external clock */
#define BOARD_OSC1_XTAL		1

#endif /* BOARD_CLK_H */
