/**
 * \file
 *
 * \brief Optimized strlen() implementation for AVR32
 *
 * - Compiler:           GNU GCC for AVR32
 * - Supported devices:  All AVR32 devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */

#define str r12

	.text
	.global strlen
	.type	strlen, @function
strlen:
	mov	r11, r12

	mov	r9, str
	andl	r9, 3, COH
	brne	.Lunaligned_str

1:	ld.w	r8, str++
	tnbz	r8
	brne	1b

	sub	r12, r11
	bfextu	r9, r8, 24, 8
	cp.w	r9, 0
	subeq	r12, 4
	reteq	r12
	bfextu	r9, r8, 16, 8
	cp.w	r9, 0
	subeq	r12, 3
	reteq	r12
	bfextu	r9, r8, 8, 8
	cp.w	r9, 0
	subeq	r12, 2
	reteq	r12
	sub	r12, 1
	retal	r12

.Lunaligned_str:
	add	pc, pc, r9 << 3
	sub	r0, r0, 0	/* 4-byte nop */
	ld.ub	r8, str++
	sub	r8, r8, 0
	breq	1f
	ld.ub	r8, str++
	sub	r8, r8, 0
	breq	1f
	ld.ub	r8, str++
	sub	r8, r8, 0
	brne	1b

1:	sub	r12, 1
	sub	r12, r11
	retal	r12
