/*This file is prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief This file contains the function declarations for usb cdc host task application
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2009 Atmel Corporation. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an Atmel
 * AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _HOST_MOUSE_TASK_H_
#define _HOST_MOUSE_TASK_H_

//_____ I N C L U D E S ____________________________________________________

#include "config.h"


//_____ M A C R O S ________________________________________________________

/**
 * host_cdc_send_encapsulated_command
 *
 * @brief this function send a format-specific packet
 *
 * @param none
 *
 * @return status
 */
#define host_cdc_send_encapsulated_command()   (usb_request.bmRequestType = USB_SETUP_SET_CLASS_INTER,\
                                                usb_request.bRequest      = SEND_ENCAPSULATED_COMMAND,\
                                                usb_request.wValue        = 0,\
                                                usb_request.wIndex        = cdc_interface_comm,\
                                                usb_request.wLength       = ENCAPSULATED_PACKET_LENGTH,\
                                                usb_request.uncomplete_read = FALSE,\
                                                host_send_control(data_stage))

/**
 * host_cdc_get_encapsulated_response
 *
 * @brief this function requests a format-specific packet
 *
 * @param none
 *
 * @return status
 */
#define host_cdc_get_encapsulated_response()   (usb_request.bmRequestType = USB_SETUP_GET_CLASS_INTER,\
                                                usb_request.bRequest      = GET_ENCAPSULATED_RESPONSE,\
                                                usb_request.wValue        = 0,\
                                                usb_request.wIndex        = cdc_interface_comm,\
                                                usb_request.wLength       = ENCAPSULATED_PACKET_LENGTH,\
                                                usb_request.uncomplete_read = FALSE,\
                                                host_send_control(data_stage))

/**
 * host_cdc_set_line_coding
 *
 * @brief this function set communication settings on the device
 *
 *
 * @param none
 *
 *
 * @return status
 */
#define host_cdc_set_line_coding()        (usb_request.bmRequestType = USB_SETUP_SET_CLASS_INTER,\
                                           usb_request.bRequest      = SET_LINE_CODING,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = cdc_interface_comm,\
                                           usb_request.wLength       = 7,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))

/**
 * host_cdc_get_line_coding
 *
 * @brief this function requests the communication settings from the device
 *
 *
 * @param none
 *
 *
 * @return status
 */
#define host_cdc_get_line_coding()        (usb_request.bmRequestType = USB_SETUP_GET_CLASS_INTER,\
                                           usb_request.bRequest      = SETUP_CDC_GET_LINE_CODING,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = cdc_interface_comm,\
                                           usb_request.wLength       = 7,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))


//_____ D E C L A R A T I O N S ____________________________________________

void host_cdc_task_init(void);
void host_cdc_task(void);
void cdc_pipe_out_usb_flush (void);
void sof_action(void);

extern U8 cdc_interface_comm;    // contains the interface number of the Management Interface
extern U8 cdc_connected;         // indicates if a CDC device is connected or not
extern U8 cdc_cpt_sof;           // SOF counter for CDC data stream manager

extern U8  cdc_stream_out_array[CDC_STREAM_OUT_SIZE];    // stream array for OUT pipe (outgoing data)
extern U8  cdc_stream_in_array[CDC_STREAM_IN_SIZE];      // stream array for IN pipe (incoming data)

#endif /* HOST_MOUSE_TASK_H_ */

