/* Prints a message whenever a top-level signal changes */
#include <stdio.h>
#include "mti.h"

static int changed(sig)
	signalID sig;
{
	char buf[200];

	sprintf(buf, "%d Signal %s changed\n", mti_Now(), mti_GetSignalName(sig));
	mti_PrintMessage(buf);
}

monitor_init()
{
	signalID sig;
	processID proc;

	sig = mti_FirstSignal(mti_GetTopRegion());
	while (sig) {
		proc = mti_CreateProcess("monitor", changed, sig);
		mti_Sensitize(proc, sig, MTI_EVENT);
		sig = mti_NextSignal();
	}
}
