#include <stdio.h>
#include "mti.h"

typedef struct {
	signalID in1;
	signalID in2;
	driverID out1;
} inst_rec;

do_and(ip)
	inst_rec *ip;
{
	int val1, val2;
	int result;

	val1 = mti_GetSignalValue(ip->in1);
	val2 = mti_GetSignalValue(ip->in2);
	result = val1 & val2;
	mti_ScheduleDriver(ip->out1, result, 0, MTI_INERTIAL);
}

and_gate_init(region, param, generics, ports)
	regionID region;
	char *param;
	interface_list *generics;
	interface_list *ports;
{
	inst_rec *ip;
	signalID outp;
	processID proc;
	extern free();

	ip = (inst_rec *)malloc(sizeof(inst_rec));
	mti_AddRestartCB(free, ip);
	ip->in1 = mti_FindPort(ports, "in1");
	ip->in2 = mti_FindPort(ports, "in2");
	outp = mti_FindPort(ports, "out1");
	ip->out1 = mti_CreateDriver(outp);

	proc = mti_CreateProcess("p1", do_and, ip);
	mti_Sensitize(proc, ip->in1, MTI_EVENT);
	mti_Sensitize(proc, ip->in2, MTI_EVENT);
}
