/*This file has been prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief Main for USB application.
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************
//!
//! @mainpage AT90USBxxx Use the bootloader API
//!
//! @section intro License
//! Use of this program is subject to Atmel's End User License Agreement.
//!
//! Please read file  \ref lic_page for copyright notice.
//!
//! @section src_code About the source code
//! This source code is usable with the following compilers:
//! - IAR Embedded Workbench (5.11A and higher)
//!
//! The other compilers aren't supported because the bootloader APIs are compiled with IAR.
//!
//! @section sample About the sample application
//! The sample code 
//!
//! ***************************************************************************

/* Copyright (c) 2007, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

//_____  I N C L U D E S ___________________________________________________

#include "config.h"
#include "lib_mcu/power/power_drv.h"
#include "lib_mcu/flash/flash_lib.h"
#include "lib_mcu/uart/uart_lib.h"
#include <stdio.h>


//_____ D E F I N I T I O N ________________________________________________

volatile U8 counter=0;
volatile U8 signature[4];
volatile U8 fuse[4];
volatile U8 temp2;


//_____ D E C L A R A T I O N _____________________________________________


int main(void)
{
   Clear_prescaler();
   uart_init();
   printf("\x0C\n\rFlash Controller Access with bootloader API test\n\r");

   printf("Reading ID1:");
   signature[0]=Flash_read_id1();
   printf("%2X\n\r",(U16)signature[0]);

   printf("Reading ID2:");
   signature[1]=Flash_read_id2();
   printf("%2X\n\r",(U16)signature[1]);

   printf("Reading ID3:");
   signature[2]=Flash_read_id3();
   printf("%2X\n\r",(U16)signature[2]);

   printf("Reading OscCal:");
   signature[3]=Flash_read_osccal();
   printf("%2X\n\r",(U16)signature[3]);

   printf("Reading lock byte:");
   fuse[0]=Flash_read_lock();
   printf("%2X\n\r",(U16)fuse[0]);

   printf("Reading Fuse Low:");
   fuse[1]=Flash_read_fuse_low();
   printf("%2X\n\r",(U16)fuse[1]);

   printf("Reading Fuse High:");
   fuse[2]=Flash_read_fuse_high();
   printf("%2X\n\r",(U16)fuse[2]);

   printf("Reading Fuse Ext:");
   fuse[3]=Flash_read_fuse_extended();
   printf("%2X\n\r",(U16)fuse[3]);

   printf("Reading FLASH@0x2001:%2X\n\r",flash_rd_byte((Uchar code*)0x2001));
   printf("Writing FLASH@0x2001 with 0x56\n\r");
   flash_wr_byte(0x2001,0x56);
   printf("Reading FLASH@0x2001:%2X\n\r",flash_rd_byte((Uchar code*)0x2001));


   printf("Reading FLASH@0x2000:%2X\n\r",flash_rd_byte((Uchar code*)0x2000));
   printf("Writing FLASH@0x2000 with 0x55\n\r");
   flash_wr_byte(0x2000,0x55);
   printf("Reading FLASH@0x2000:%2X\n\r",flash_rd_byte((Uchar code*)0x2000));

   printf("Reading FLASH@0x2001:%2X\n\r",flash_rd_byte((Uchar code*)0x2001));
   printf("Writing FLASH@0x2001 with 0xFF\n\r");
   flash_wr_byte(0x2001,0xFF);
   printf("Reading FLASH@0x2001:%2X\n\r",flash_rd_byte((Uchar code*)0x2001));

   printf("Reading FLASH@0x2000:%2X\n\r",flash_rd_byte((Uchar code*)0x2000));
   printf("Writing FLASH@0x2000 with 0xFF\n\r");
   flash_wr_byte(0x2000,0xFF);
   printf("Reading FLASH@0x2000:%2X\n\r",flash_rd_byte((Uchar code*)0x2000));

   printf("------------ End of example ------------\n");
   while(1);
}
