/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.atusbhid;

import com.atmel.atusbhidjni.AtUsbHidJni;

public class AtUsbHidSimple {
    static final int VID = 1003;
    static final int PID1 = 8211;
    static final int PID2 = 8209;

    public static void main(String[] stringArray) {
        AtUsbHidJni atUsbHidJni = new AtUsbHidJni();
        if (atUsbHidJni.loadLibraryUsbHid()) {
            System.out.println("AtUsbHidSimple.main():LoadLibrary");
        } else {
            System.out.println("AtUsbHidSimple.main():not able to Load Library");
            System.exit(0);
        }
        System.out.println("AtUsbHidSimple.main():Find device (VID=0x2013)");
        int n = atUsbHidJni.findHidDevice(1003, 8211);
        switch (n) {
            case 1: {
                System.out.println("AtUsbHidSimple.main():Connected to the device");
                break;
            }
            case -1: {
                System.err.println("AtUsbHidSimple.main():Usb Device Not Found");
                break;
            }
            case -2: {
                System.err.println("AtUsbHidSimple.main():Usb no capabilities");
                break;
            }
            default: {
                System.err.println("AtUsbHidSimple.main():Usb Unknown Error");
            }
        }
        if (1 != n) {
            System.out.println("AtUsbHidSimple.main():Find device (VID=0x2011)");
            n = atUsbHidJni.findHidDevice(1003, 8209);
            switch (n) {
                case 1: {
                    System.out.println("AtUsbHidSimple.main():Connected to the device");
                    break;
                }
                case -1: {
                    System.err.println("AtUsbHidSimple.main():Usb Device Not Found");
                    System.exit(0);
                    break;
                }
                case -2: {
                    System.err.println("AtUsbHidSimple.main():Usb no capabilities");
                    System.exit(0);
                    break;
                }
                default: {
                    System.err.println("AtUsbHidSimple.main():Usb Unknown Error");
                    System.exit(0);
                }
            }
        }
        boolean bl = false;
        while (!bl) {
            byte[] byArray = new byte[atUsbHidJni.getOutputReportLength()];
            byte[] byArray2 = null;
            AtUsbHidSimple.delay(100);
            byArray[0] = 49;
            byArray[1] = 49;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 50;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 51;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 52;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[0] = 48;
            byArray[1] = 49;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 50;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 51;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray[1] = 52;
            atUsbHidJni.writeData(byArray);
            AtUsbHidSimple.delay(100);
            byArray2 = atUsbHidJni.readData();
            if (byArray2.length == 0) continue;
            System.out.println("AtUsbHidSimple.main():Key pressed");
            bl = true;
        }
        System.out.println("AtUsbHidSimple.main():Close device");
        atUsbHidJni.closeDevice();
    }

    static void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }
}

