// ******************************************************************
// * Header file for OTG HID Demonstrationpackage for AT90USB647/1287
// ******************************************************************

extern void otg_user_task_init(void);
extern void otg_user_task(void);
extern void Led_print_otg_status(void);

// USB/OTG status constants
// ========================
#define   SESSION_HOST    0xF0
#define   SESSION_DEVICE  0x0F
#define   SESSION_OFF     0x00

#define   USB_NEW_PACKET  0xFF
#define   USB_READ_PACKET 0x00

#define   OTG_MOUSE_SPEED 15

#define   Clear_usb_report()          (Usb_report[0]=0, Usb_report[1]=0, Usb_report[2]=0, Usb_report[3]=0)


#if (TARGET_BOARD == STK525)
  // STK525 LEDs :
  #define   Led_usb_connected_on()      Led0_on()
  #define   Led_usb_connected_off()     Led0_off()
  
  #define   Led_hid_toggle()            Led1_toggle()
  #define   Led_hid_off()               Led1_off()
  
  #define   Led_unsupported_on()        Led2_on()
  #define   Led_unsupported_off()       Led2_off()
  
  #define   Led_noresponse_on()         Led3_on()
  #define   Led_noresponse_off()        Led3_off()
#elif (TARGET_BOARD == USBKEY)
  // USB Key LEDs :
  #define   Led_usb_connected_on()      Led1_on()
  #define   Led_usb_connected_off()     Led1_off()
  
  #define   Led_hid_toggle()            Led2_toggle()
  #define   Led_hid_off()               Led2_off()
  
  #define   Led_unsupported_on()        Led3_on()
  #define   Led_unsupported_off()       Led3_off()
  
  #define   Led_noresponse_on()         Led0_on()
  #define   Led_noresponse_off()        Led0_off()
#endif


// **************************
// **  TIME-OUT Management **
// **************************

#define   Timer_select(ts)      Timer16_select(ts)
#define   TIMER_DELAY           TIMER16_3

// User can configure Timer3 to generate DELAY (mutliple of 1 millisecond)
// Max delay : 2100 ms
#define   Delay_config(ms)      (Timer16_set_clock(TIMER16_CLKIO_BY_256), \
                                Timer16_set_mode_output_a(TIMER16_COMP_MODE_NORMAL), \
                                Timer16_set_waveform_mode(TIMER16_WGM_CTC_OCR), \
                                Timer16_set_compare_a((U16)(31)*(U16)(ms)))
#define   Delay_reset()         (Timer16_set_counter(0x0000), Timer16_clear_compare_a_it())
#define   Is_delay_end()        (Timer16_get_compare_a_it())
#define   Is_not_delay_end()    (!(Timer16_get_compare_a_it()))


// A macro is also defined to simplify pushbutton debouncing
#define   Bp_delay_debounce()   { Timer_select(TIMER_DELAY); Delay_config(20); \
                                  Delay_reset(); while (Is_not_delay_end());}

//_____ M A C R O S ________________________________________________________

/**
 * @brief this function send the hid specific request "hid_set_idle"
 *
 *
 * @param none
 *
 *
 * @return status
 */
#define host_hid_set_idle()                (usb_request.bmRequestType = 0x21,\
                                           usb_request.bRequest      = 0x0A,\
                                           usb_request.wValue        = 0,\
                                           usb_request.wIndex        = 0,\
                                           usb_request.wLength       = 0,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))

/**
 * @brief this function send the hid specific request "get hid repport descriptor"
 *
 *
 * @param none
 *
 *
 * @return status
 */
#define host_get_hid_repport_descriptor()  (usb_request.bmRequestType = 0x81,\
                                           usb_request.bRequest      = 0x06,\
                                           usb_request.wValue        = 0x2200,\
                                           usb_request.wIndex        = 0,\
                                           usb_request.wLength       = SIZEOF_DATA_STAGE,\
                                           usb_request.uncomplete_read = FALSE,\
                                           host_send_control(data_stage))

