//! @file config.h,v
//!
//! Copyright (c) 2006 Atmel.
//!
//! Please read file license.txt for copyright notice.
//!
//! This file contains the system configuration definition
//!
//! @version 1.2 at90usb128-otg-dual_role-toggle-1_0_0 $Id: config.h,v 1.2 2007/02/19 08:21:57 arobert Exp $
//!
//! @todo
//! @bug

#ifndef _CONFIG_H_
#define _CONFIG_H_

//! @defgroup global_config Application configuration
//! @{

//_____ I N C L U D E S ____________________________________________________


#ifdef AVRGCC
   #define __AVR_AT90USBxxx__
#endif

#include "lib_mcu\compiler.h" //!< Compiler definitions


#ifdef AVRGCC
   #include <avr/io.h>
#else
   #include "lib_mcu\mcu.h" //!< Register declaration
#endif
#include "conf/conf_scheduler.h" //!< Scheduler tasks declaration

#define  STK525   0
#define  USBKEY   1
#define  SPIDER   2

//! Enable or not the ADC usage
#define USE_ADC

#define USE_TIMER16   BOTH_TIMER16

//! To include proper target hardware definitions, select
//! target board (USBKEY or STK525)
#define TARGET_BOARD  STK525

#if (TARGET_BOARD==USBKEY)
   //! @warning for #define USBKEY_HAS_321_DF, only first prototypes versions have AT45DB321C memories
   //! should be undefined for std series
   //#define USBKEY_HAS_321_DF
   #include "lib_board\usb_key\usb_key.h"
#elif (TARGET_BOARD==STK525)
   #include "lib_board\stk_525\stk_525.h"
#else
   #error TARGET_BOARD must be defined somewhere
#endif

//! CPU core frequency in kHz
#define FOSC 8000

// -------- END Generic Configuration -------------------------------------

#define HOST_SYNC_MODE  ENABLE

// UART Sample configuration, if we have one ... __________________________
#define BAUDRATE        57600
#define USE_UART2
#define UART_U2

#define uart_putchar putchar
#define r_uart_ptchar int
#define p_uart_ptchar int


// ADC Sample configuration, if we have one ... ___________________________


//! ADC Prescaler value
#define ADC_PRESCALER 32
//! Right adjust
#define ADC_RIGHT_ADJUST_RESULT 1
//! AVCC As reference voltage (See adc_drv.h)
#define ADC_INTERNAL_VREF  2

#define SBC_VENDOR_ID         {'A','T','M','E','L',' ',' ',' '}      // 8 Bytes only
#define SBC_PRODUCT_ID        {'A','T','9','0','U','S','B','1','2','8',' ','M',' ','S',' ',' '}  // 16 Bytes only
#define SBC_REVISION_ID       {'0','.','0','0'}  // 4 Bytes only

#define NO_SUPPORT_USB_PING_PONG

#define DUMMY     GPIOR1
#define SPI_CONFIG 0x00

//!--------- Device Mouse configuration -------------------------------------
#define NB_IDLE_POLLING_SOF  2               //! ms before looking for new mouse hardware event
#define MOUSE_SPEED          2               //! Dx Dy for mouse repport


#define FLASH_PAGE_SIZE       0x100

// USHELL configuration, if we have one ... ___________________________

#define USHELL_DFU            ENABLE
#define USHELL_USB            ENABLE
#define USHELL_HID            ENABLE
#define USHELL_HISTORY        1

#define MAX_FILE_LENGHT       30

#define TRACE                 DISABLE

#if (TRACE==ENABLE)
extern void ushell_trace_msg(U8 code *str);
#define LOG_STR_CODE(s)    ushell_trace_msg(s)
#endif

//! @}

#endif // _CONFIG_H_

