//! @file conf_usb.h,v
//!
//! Copyright (c) 2006 Atmel.
//!
//! Please read file license.txt for copyright notice.
//!
//! This file contains the possible external configuration of the USB
//!
//!
//! @version 1.1 at90usb128-otg-dual_role-toggle-1_0_0 $Id: conf_usb.h,v 1.1 2007/02/16 13:10:39 arobert Exp $
//!
//! @todo
//! @bug
#ifndef _CONF_USB_H_
#define _CONF_USB_H_



//! @defgroup usb_general_conf USB application configuration
//!
//! @{


   // _________________ OTG MODE CONFIGURATION ____________________________
   //
   //! @defgroup OTG_op_mode OTG operating modes configuration
   //! defines to enable device or host usb operating modes
   //! supported by the application
   //! @{

      //! @brief ENABLE to enable OTG module (support A- and B- Device roles)
      //!
      //! Possible values ENABLE or DISABLE
      #define USB_OTG_FEATURE                         ENABLED

      //! @brief Selects the general Vbus delivery mode : insertion OR usage based
      //!
      //! Possible values are : ENABLE for an application that never release Vbus when A-plug inserted
      //!                       DISABLE for an application where Vbus is delivered after a SRP or user request
      #define OTG_VBUS_AUTO_WHEN_A_PLUG               DISABLED

      //! @brief Selects the messaging method for OTG No Silent Failure spec.
      //!
      //! A compliant OTG device must at least handle 3 Failure messages : "Device No Response", "Unsupported Device" and "Unsupported Hub"
      //! Functions must be defined for communicating messages to user (LCD display, LEDs...)
      //! The values available for this parameter are :
      //!  - OTGMSG_ALL : all messages (events and failures) are displayed
      //!     In this case, the following functions must be defined in user application firmware :
      //!       # "void Otg_messaging_init(void)", this function is called at start up to initialize the messaging peripheral
      //!       # "void Otg_output_failure_msg(U8)", displays the failure message choosen by ID number (see "usb_task.h")
      //!       # "void Otg_output_failure_clear(void)", clears the current failure message
      //!       # "void Otg_output_event_msg(U8)", displays the event message choosen by ID number
      //!       # "void Otg_output_event_clear(void)", clears the current event message
      //!  - OTGMSG_FAIL : only failure messages are displayed
      //!     In this case, the following functions must be defined in user application firmware :
      //!       # "void Otg_messaging_init(void)", this function is called at start up to initialize the messaging peripheral
      //!       # "void Otg_output_failure_msg(U8)", displays the failure message choosen by ID number (see "usb_task.h")
      //!       # "void Otg_output_failure_clear(void)", clears the current failure message
      //!  - OTGMSG_NONE  : messages are not displayed (not OTG compliant device)
      #define OTG_MESSAGING_OUTPUT                    OTGMSG_FAIL

      //! @brief Timer selection for OTG timings requirements
      //!
      //! Possible values TIMER16_1 or TIMER16_3
      #define OTG_USE_TIMER                           TIMER16_1
      //! Possible values : OTG_USE_TIMER (if no more timer needed), or BOTH_TIMER16 (if user application uses another timer)
      #define USE_TIMER16                             BOTH_TIMER16

      //! @brief ENABLE to make the A-Device send a SetFeature(b_hnp_enable) just after a SRP has been received
      //!
      //! This feature must be ENABLED to pass the OTG compliance program
      //! Possible values ENABLE or DISABLE
      #define OTG_ENABLE_HNP_AFTER_SRP                ENABLED

      //! @brief Selects the SRP pulse for which the A Device will react and rise Vbus
      //!
      //! The value is VBUS_PULSE or DATA_PULSE
      #define OTG_ADEV_SRP_REACTION                   VBUS_PULSE
   //! @}


   // _________________ USB MODE CONFIGURATION ____________________________
   //
   //! @defgroup USB_op_mode USB operating modes configuration
   //! defines to enable device or host usb operating modes
   //! supported by the application
   //! @{

      //! @brief ENABLE to activate the host software library support
      //!
      //! Possible values ENABLE or DISABLE
      #define USB_HOST_FEATURE            ENABLED

      //! @brief ENABLE to activate the device software library support
      //!
      //! Possible values ENABLE or DISABLE
      #define USB_DEVICE_FEATURE          ENABLED

   //! @}

   // _________________ USB REGULATOR CONFIGURATION _______________________
   //
   //! @defgroup USB_reg_mode USB regulator configuration
   //! @{

   //! @brief Enable the internal regulator for USB pads
   //!
   //! When the application voltage is lower than 3.5V, to optimize power consumption
   //! the internal USB pads regulatr can be disabled.
#ifndef USE_USB_PADS_REGULATOR
   #define USE_USB_PADS_REGULATOR   ENABLE      // Possible values ENABLE or DISABLE
#endif
   //! @}

   // _________________ HOST MODE CONFIGURATION ____________________________
   //
   //! @defgroup USB_host_mode_cfg USB host operating mode configuration
   //!
   //! @{

   #define HID_CLASS          0x03
   #define MS_CLASS           0x08
   #define NO_SUBCLASS        0x00
   #define BOOT_SUBCLASS      0x01
   #define MOUSE_PROTOCOL     0x02
   #define NO_PROTOCOL        0x00


   //!   @brief VID/PID supported table list
   //!
   //!   This table contains the VID/PID that are supported by the reduced host application
   //!   VID_PID_TABLE format definition:
   //!
   //!   #define VID_PID_TABLE      {VID1, number_of_pid_for_this_VID1, PID11_value,..., PID1X_Value \n
   //!                              ...\n
   //!                              ,VIDz, number_of_pid_for_this_VIDz, PIDz1_value,..., PIDzX_Value}
   //! The TEST DEVICE must not be included : VID=0x1A0A & PID=0xBADD
   //! For the OTG Compliance the B-OPT uses a PID=0x1234 as the "Unsupported device"
   #define VID_PID_TABLE            { 0x03EB, 1, 0x2031 }

   //!   @brief CLASS/SUBCLASS_PROTOCOL supported table list
   //!
   //!   This table contains the CLASS/SUBCLASS/PROTOCOL that is supported by the reduced host application
   //!   This table definition allows to extended the reduced application device support to an entire Class/
   //!   /subclass/protocol instead of a simple VID/PID table list.
   //!
   //!   CLASS_SUBCLASS_PROTOCOL format definition: \n
   //!   #define CLASS_SUBCLASS_PROTOCOL  {CLASS1, SUB_CLASS1,PROTOCOL1, \n
   //!                                     ...\n
   //!                                     CLASSz, SUB_CLASSz,PROTOCOLz}
   #define CLASS_SUBCLASS_PROTOCOL     {0x00, 0x00, 0x00,\
                                       MS_CLASS, 0x06, 0x50,\
                                       HID_CLASS, NO_SUBCLASS, MOUSE_PROTOCOL,\
                                       HID_CLASS, BOOT_SUBCLASS, MOUSE_PROTOCOL,\
                                       HID_CLASS, NO_SUBCLASS, NO_PROTOCOL}
   /* ^^ Irrelevant here ^^ */

   //! The size of RAM buffer reserved of descriptors manipulation
   #define SIZEOF_DATA_STAGE        250

   //! The address that will be assigned to the connected device
   #define DEVICE_ADDRESS           0x05

   //! The maximum number of interface that can be supported (composite device)
   #define MAX_INTERFACE_SUPPORTED  0x03

   //! The maximum number of endpoints per interface supported
   #define MAX_EP_PER_INTERFACE     3

   //! The host controller will be limited to the strict VID/PID list.
   //! When enabled, if the device PID/VID does not belongs  to the supported list,
   //! the host controller library will not go to deeper configuration, but to error state.
   #define HOST_STRICT_VID_PID_TABLE      ENABLE

   //! Try to configure the host pipe according to the device descriptors received
   #define HOST_AUTO_CFG_ENDPOINT         ENABLE

   //! Host start of frame interrupt always enable
   #define HOST_CONTINUOUS_SOF_INTERRUPT  DISABLE

   //! When Host error state detected, goto unattached state
   #define HOST_ERROR_RESTART             ENABLE

   //! USB host pipes transfers use USB communication interrupt (allows to use none blocking functions)
   #define USB_HOST_PIPE_INTERRUPT_TRANSFER  ENABLE

   //! Force WDT reset upon ID pin change
   #define ID_PIN_CHANGE_GENERATE_RESET   ENABLE

   //! Enable Timeout delay (time) for host transfer
   #define TIMEOUT_DELAY_ENABLE           ENABLE

   //! delay 1/4sec (250ms) before timeout value
   #define TIMEOUT_DELAY               10

   //! Enable cpt NAK Timeout for host transfer
   #define NAK_TIMEOUT_ENABLE          DISABLE

   //! Number of NAK handshake before timeout for transmit functions (up to 0xFFFF)
   #define NAK_SEND_TIMEOUT            0x0FFF

   //! NAKNumber of NAK handshake before timeout for receive functions (up to 0xFFFF)
   #define NAK_RECEIVE_TIMEOUT         0x0FFF

   //! For reduced host only allows to control VBUS generator with PIO PE.7
   #define SOFTWARE_VBUS_CTRL          ENABLE

   #if (HOST_AUTO_CFG_ENDPOINT==FALSE)
      //! If no auto configuration of EP, map here user function
      #define        User_configure_endpoint()
   #endif

   //! @defgroup host_cst_actions USB host custom actions
   //!
   //! @{
   // write here the action to associate to each USB host event
   // be carefull not to waste time in order not disturbing the functions
   #define Usb_id_transition_action()
   #define Host_device_disconnection_action()
   #define Host_device_connection_action()
   #define Host_sof_action()
   #define Host_suspend_action()
   #define Host_hwup_action()
   #define Host_vbus_action()
#if (USB_OTG_FEATURE == ENABLED)
   #define Host_device_not_supported_action()         otg_not_supported_device()
#else
   #define Host_device_not_supported_action()
#endif
   #define Host_device_supported_action()
#if (USB_OTG_FEATURE == ENABLED)
   #define Host_device_error_action()                 otg_not_supported_device()
#else
   #define Host_device_error_action()
#endif
   //! @}

extern void set_power_down_mode(void);
extern void host_sof_action(void);
//extern void Lcd_print_otg_status(U8);
extern volatile U8 spider_connected;
   //! @}


// _________________ DEVICE MODE CONFIGURATION __________________________

   //! @defgroup USB_device_mode_cfg USB device operating mode configuration
   //!
   //! @{
#define NB_ENDPOINTS          1  // number of endpoints in the application
#define EP_SPIDER_IN          1

#define Usb_unicode(a)			((U16)(a))

   //! @defgroup device_cst_actions USB device custom actions
   //!
   //! @{
   // write here the action to associate to each USB event
   // be carefull not to waste time in order not disturbing the functions
#define Usb_sof_action()
#define Usb_wake_up_action()
#define Usb_resume_action()
#define Usb_suspend_action()
  #define Usb_reset_action()
#define Usb_vbus_on_action()
#define Usb_vbus_off_action()
#define Usb_set_configuration_action()
   //! @}

   //! @}

//! @}

#endif // _CONF_USB_H_
