/*
 * Decompiled with CFR 0.152.
 */
package com.atmel.atusbhid.demo;

import com.atmel.atusbhid.demo.Gui;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.ParseException;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.MaskFormatter;

public class PanelButton
extends JPanel {
    private static final String VID = "0x03EB";
    private static final String PID = "0x2013";
    private static final String CONNECT = "Connect";
    private static final String DISCONNECT = "Disconnect";
    private static final long serialVersionUID = 1381518020027414222L;
    private JPanel jPanelButton = null;
    private JLabel jLabelVID = null;
    private JFormattedTextField jTextFieldVID = null;
    private JLabel jLabelPID = null;
    private JFormattedTextField jTextFieldPID = null;
    private JButton jButtonConnect = null;
    private JButton jButtonISP = null;
    private Gui jParent = null;
    private JCheckBox jCheckBoxAutoConnect = null;

    public PanelButton(Gui jParent) {
        this.jParent = jParent;
    }

    public JPanel getJPanelButton() {
        if (this.jPanelButton == null) {
            this.jLabelVID = new JLabel();
            this.jLabelVID.setText("VID");
            this.jPanelButton = new JPanel();
            this.jPanelButton.setLayout(new FlowLayout());
            this.jPanelButton.add((Component)this.jLabelVID, null);
            this.jPanelButton.add((Component)this.getJTextFieldVid(), null);
            this.jPanelButton.add((Component)this.getJLabelPID(), null);
            this.jPanelButton.add((Component)this.getJTextFieldPID(), null);
            this.jPanelButton.add((Component)this.getJCheckBoxAutoConnect(), null);
            this.jPanelButton.add(Box.createHorizontalStrut(30));
            this.jPanelButton.add((Component)this.getJButtonConnect(), null);
            this.jPanelButton.add((Component)this.getJButtonISP(), null);
        }
        return this.jPanelButton;
    }

    private JTextField getJTextFieldVid() {
        if (this.jTextFieldVID == null) {
            try {
                MaskFormatter formatter = new MaskFormatter("0x****");
                formatter.setValidCharacters("0123456789abcdefABCDEF");
                formatter.setPlaceholderCharacter('?');
                this.jTextFieldVID = new JFormattedTextField(formatter);
                this.jTextFieldVID.setAction(null);
            }
            catch (ParseException e) {
                this.jTextFieldVID = new JFormattedTextField();
                e.printStackTrace();
            }
            this.jTextFieldVID.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldVID.setText(VID);
        }
        return this.jTextFieldVID;
    }

    private JLabel getJLabelPID() {
        if (this.jLabelPID == null) {
            this.jLabelPID = new JLabel();
            this.jLabelPID.setText("PID");
        }
        return this.jLabelPID;
    }

    private JTextField getJTextFieldPID() {
        if (this.jTextFieldPID == null) {
            try {
                MaskFormatter formatter = new MaskFormatter("0x****");
                formatter.setValidCharacters("0123456789abcdefABCDEF");
                formatter.setPlaceholderCharacter('?');
                this.jTextFieldPID = new JFormattedTextField(formatter);
            }
            catch (ParseException e) {
                this.jTextFieldPID = new JFormattedTextField();
                e.printStackTrace();
            }
            this.jTextFieldPID.setPreferredSize(new Dimension(50, 20));
            this.jTextFieldPID.setText(PID);
        }
        return this.jTextFieldPID;
    }

    private JButton getJButtonConnect() {
        if (this.jButtonConnect == null) {
            this.jButtonConnect = new JButton();
            this.jButtonConnect.setPreferredSize(new Dimension(100, 26));
            this.jButtonConnect.setText(CONNECT);
            this.jButtonConnect.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (PanelButton.this.jButtonConnect.getText().contentEquals(PanelButton.CONNECT)) {
                        PanelButton.this.jParent.setDeviceConnected(true);
                    } else {
                        PanelButton.this.jParent.setDeviceConnected(false);
                    }
                }
            });
        }
        return this.jButtonConnect;
    }

    private JButton getJButtonISP() {
        if (this.jButtonISP == null) {
            this.jButtonISP = new JButton();
            this.jButtonISP.setText("Firmware upgrade");
            this.jButtonISP.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelButton.this.jParent.startIsp();
                }
            });
        }
        return this.jButtonISP;
    }

    public int getVid() {
        return Integer.decode(this.getJTextFieldVid().getText());
    }

    public int getPid() {
        return Integer.decode(this.getJTextFieldPID().getText());
    }

    public void setCommunicationEnable(boolean b) {
        this.getJButtonISP().setEnabled(b);
        if (!b) {
            this.getJButtonConnect().setText(CONNECT);
        } else {
            this.getJButtonConnect().setText(DISCONNECT);
        }
    }

    private JCheckBox getJCheckBoxAutoConnect() {
        if (this.jCheckBoxAutoConnect == null) {
            this.jCheckBoxAutoConnect = new JCheckBox();
            this.jCheckBoxAutoConnect.setAction(null);
            this.jCheckBoxAutoConnect.setText("Auto-Connect");
            this.jCheckBoxAutoConnect.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PanelButton.this.jParent.setAutoConnect(PanelButton.this.jCheckBoxAutoConnect.isSelected());
                }
            });
        }
        return this.jCheckBoxAutoConnect;
    }
}

