/*This file has been prepared for Doxygen automatic documentation generation.*/
//! \file *********************************************************************
//!
//! \brief This file contains the function declarations for USB Host Audio task application
//!
//! - Compiler:           IAR EWAVR and GNU GCC for AVR
//! - Supported devices:  AT90USB1287, AT90USB1286, AT90USB647, AT90USB646
//!
//! \author               Atmel Corporation: http://www.atmel.com \n
//!                       Support and FAQ: http://support.atmel.no/
//!
//! ***************************************************************************

/* Copyright (c) 2007, Atmel Corporation All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of ATMEL may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
 * SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _HOST_MOUSE_TASK_H_
#define _HOST_MOUSE_TASK_H_

//_____ I N C L U D E S ____________________________________________________

#include "config.h"


//_____ M A C R O S ________________________________________________________

// USB Audio Class constants
#define     AUDIO_AS_INTERFACE_CLASS        0x01
#define     AUDIO_AS_INTERFACE_SUB_CLASS    0x02
#define     SET_CUR                         0x01
#define     CS_MUTE                         0x0100


// D/A Converter
#define     PORT_A_RIGHT    0
#define     PORT_A_CPLX     1


// =================================================================================================================================
// Check and modify the following lines to fit with your external D/A converter :
#define     DAC_OUT                         PORT_A_CPLX       // PORT_A_RIGHT or PORT_A_CPLX : defines the external R-2R ladder used
                                                              // See documentation schematics for more details
#define     Dac_output_init()               (PORTA = 0x00, DDRA = 0xFF)   // Init D/A output port
// =================================================================================================================================


// Specific request : this request can be used to control the Mute feature if supported by the device
#define     MUTE_ON                         TRUE
#define     MUTE_OFF                        FALSE
#define     host_audio_set_cur(cs_mute)     (data_stage[0] = cs_mute,             \
                                            usb_request.bmRequestType = USB_SETUP_SET_CLASS_INTER,     \
                                            usb_request.bRequest      = SET_CUR,  \
                                            usb_request.wValue        = CS_MUTE,  \
                                            usb_request.wIndex        = 0,        \
                                            usb_request.wLength       = 1,        \
                                            usb_request.uncomplete_read = FALSE,  \
                                            host_send_control(data_stage))


//_____ D E C L A R A T I O N S ____________________________________________

void  host_audio_task_init(void);
void  host_audio_task(void);

void  sof_action(void);
void  DAC_SendPort(U8);

extern volatile U8 audio_connected;         // indicates if a CDC device is connected or not
extern volatile U8 audio_cpt_sof;           // SOF counter for CDC data stream manager

#endif /* HOST_MOUSE_TASK_H_ */

