#! /usr/bin/env python

# This is a USB test suite for USB devices. To use it, load an
# application featuring the USB Test Function into the target,
# connect it to the PC and run this program.
#
# You need PyUnit and PyUSB installed on the host PC for this test to
# work. PyUnit is included with Python 2.1 and later.

import sys
import unittest
import usb
import usbtest

test_vid = 0x03eb	# Atmel Corp.
test_pid = 0x21fe	# ID reserved for internal testing

def run_test(usbdev):
	print "Testing device %s (VID: %04x PID: %04x)" % (usbdev.filename,
			usbdev.idVendor, usbdev.idProduct)
	runner = unittest.TextTestRunner()
	suite = usbtest.suite(usbdev)
	runner.run(suite)

busses = usb.busses()
for bus in busses:
	devices = bus.devices
	for dev in devices:
		if dev.idVendor == test_vid and dev.idProduct == test_pid:
			run_test(dev)
