#! /bin/sh

TEMP=`getopt -o t: -n 'makeall.sh' -- "$@"`
if [ $? != 0 ]; then
	echo "Terminating..." >&2
	exit 1
fi

eval set -- "$TEMP"

TARGET="all"

while true; do
	case "$1" in
	-t)
		TARGET="$2"
		shift 2
		;;
	--)
		shift
		break
		;;
	*)
		echo "Internal error!"
		exit 1
		;;
	esac
done

if [ -z "$1" ]; then
	for dir in apps/*; do
		if [ -z "$BOARD" -o -f $dir/config-$BOARD.mk ]; then
			make -C $dir $TARGET || exit 1
		fi
	done
	exit 0
fi

for app do
	make -C apps/$app $TARGET || exit 1
done
