/**
 * \file
 *
 * \brief SCSI Reduced Block Commands
 *
 * This file contains definitions of some of the commands found in the
 * SCSI RBC standard.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef SCSI_RBC_PROTOCOL_H_INCLUDED
#define SCSI_RBC_PROTOCOL_H_INCLUDED

#include <scsi/spc_protocol.h>

#define SCSI_CMD_START_STOP_UNIT		0x1b
#define SCSI_CMD_READ_CAPACITY10		0x25
#define SCSI_CMD_READ10				0x28
#define SCSI_CMD_WRITE10			0x2a
#define SCSI_CMD_VERIFY10			0x2f

struct rbc_device_param_page {
	uint8_t	page_code;
#define RBC_DEVICE_PARAM_PAGE_CODE	(SCSI_PAGE_CODE_PS | 0x06)
	uint8_t	page_length;
#define RBC_DEVICE_PARAM_PAGE_LENGTH	(0x0b)
	uint8_t	flags2;
#define RBC_DEVICE_PARAM_WCD		(1 << 0)
	uint8_t	logical_block_size[2];
	uint8_t number_of_logical_blocks[5];
	uint8_t power_performance;
	uint8_t	flags11;
#define RBC_DEVICE_PARAM_READD		(1 << 3)
#define RBC_DEVICE_PARAM_WRITED		(1 << 2)
#define RBC_DEVICE_PARAM_FORMATD	(1 << 1)
#define RBC_DEVICE_PARAM_LOCKD		(1 << 0)
	uint8_t reserved;
};

#endif /* SCSI_RBC_PROTOCOL_H_INCLUDED */
