/**
 * \file
 *
 * \brief Power Manager v2 chip-independent support
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices with a PM v3 module
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef PM_PM_V3_H_INCLUDED
#define PM_PM_V3_H_INCLUDED

#include <io.h>
#include <assert.h>
#include <util.h>
#include <chip/clk.h>
#include <chip/memory-map.h>
#include <pm/pm_v3_regs.h>
#include <pm/pm_common.h>

#define PM_VERSION	PM_MKVERSION(3, 0, 0)

static inline int pm_enable_genclk(unsigned int id, enum pm_genclk_src source,
		unsigned int divider)
{
	uint32_t	gcctrl;

	assert(divider != 0);
	
	gcctrl = PM_GCCTRL_OSCSEL(source);
	assert(!(gcctrl & ~PM_GCCTRL_OSCSEL_MASK));
	gcctrl |= PM_GCCTRL_CEN;

	if (divider > 1)
		gcctrl |= (PM_GCCTRL_DIVEN
				| PM_GCCTRL_DIV(div_ceil(divider, 2) - 1));
	pm_write_reg(GCCTRL(id), gcctrl);

	return 0;
}

#endif /* PM_PM_V3_H_INCLUDED */
