/**
 * \file
 *
 * \brief LED control interface
 *
 * This file includes the board-specific LED implementation and extends
 * it. Please include this file instead of <board/led.h>.
 *
 * - Compiler:           IAR EWAVR32 and GNU GCC for AVR32
 * - Supported devices:  All devices
 * - AppNote:
 *
 * \author               Atmel Corporation: http://www.atmel.com \n
 *                       Support and FAQ: http://support.atmel.no/
 *
 * \page License
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * 3. The name of Atmel may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 *
 * 4. This software may only be redistributed and used in connection with an
 * Atmel AVR product.
 *
 * THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * EXPRESSLY AND SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
#ifndef LEDS_H_INCLUDED
#define LEDS_H_INCLUDED

#include <board/led.h>

#ifdef CONFIG_LED_BLINK

#include <timer_tc.h>
#include <types.h>

/**
 * \internal
 * \brief LED blinking state
 *
 * This structure keeps track of the state associated with a blinking
 * LED.
 */
struct blinking_led {
	/** ID of the blinking LED */
	enum board_led_id	led;
	/** Time between each toggle in milliseconds */
	unsigned int		period_ms;
	/** Timer task responsible for doing the blinking */
	struct timer_task	task;
	/** Current state of the LED */
	bool			state;
	/** True if blinking is enabled */
	bool			enabled;
	/** True if timer task is active */
	bool			active;
};

void led_blink_start(struct blinking_led *blink);
void led_blink_stop(struct blinking_led *blink);
void led_blink_init(struct blinking_led *blink, enum board_led_id led,
		unsigned int period_ms);

#endif /* CONFIG_LED_BLINK */

#endif /* LEDS_H_INCLUDED */
